/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.as.server.ServerState;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.remoting3.Channel;

@MessageLogger(projectCode="JBAS")
public interface HostControllerLogger
extends BasicLogger {
    public static final HostControllerLogger ROOT_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)HostControllerLogger.class.getPackage().getName());
    public static final HostControllerLogger AS_ROOT_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)"org.jboss.as");
    public static final HostControllerLogger CONTROLLER_MANAGEMENT_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)"org.jboss.as.domain.controller.mgmt");
    public static final HostControllerLogger DOMAIN_LOGGER = (HostControllerLogger)Logger.getMessageLogger(HostControllerLogger.class, (String)"org.jboss.as.domain");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10900, value="Could not connect to remote domain controller %s:%d: %s")
    public void cannotConnect(String var1, int var2, IOException var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10901, value="Could not connect to master. Aborting. Error was: %s")
    public void cannotConnectToMaster(Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10902, value="Creating http management service using network interface (%s) port (%d) securePort (%d)")
    public void creatingHttpManagementService(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10903, value="Error retrieving domain model from remote domain controller %s:%d: %s")
    public void errorRetrievingDomainModel(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10904, value="Existing server [%s] with status: %s")
    public void existingServerWithState(String var1, ServerStatus var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10905, value="Failed to create server process %s")
    public void failedToCreateServerProcess(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10906, value="Failed to send reconnect message to server %s")
    public void failedToSendReconnect(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10907, value="Failed to start server (%s)")
    public void failedToStartServer(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10908, value="Failed to stop server (%s)")
    public void failedToStopServer(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10909, value="Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.")
    public void gracefulShutdownNotSupported(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10910, value="Ignoring <permgen> for jvm '%s' type jvm: %s")
    public void ignoringPermGen(JvmType var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10911, value="No <domain-controller> configuration was provided and the current running mode ('%s') requires access to the Domain Controller host. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.")
    public void noDomainControllerConfigurationProvided(RunningMode var1, String var2, RunningMode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10912, value="No security realm defined for http management service, all access will be unrestricted.")
    public void noSecurityRealmDefined();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10913, value="No server called %s available")
    public void noServerAvailable(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10914, value="Connection to remote host-controller closed. Trying to reconnect.")
    public void lostRemoteDomainConnection();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10915, value="Ignoring <option value=\"%s\" for jvm '%s' since '%s' was set")
    public void optionAlreadySet(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10916, value="Reconnected to master")
    public void reconnectedToMaster();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10917, value="Reconnecting server %s")
    public void reconnectingServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10918, value="Registered remote slave host \"%s\", %s")
    public void registeredRemoteSlaveHost(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10919, value="Registering server %s")
    public void registeringServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10920, value="Server [%s] registered using connection [%s]")
    public void serverRegistered(String var1, Channel var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10921, value="Graceful shutdown of the handler used for messages from other Host Controllers did not cleanly complete but shutdown of the underlying communication channel is proceeding")
    public void serviceShutdownIncomplete(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10922, value="Starting server %s")
    public void startingServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10923, value="Stopping server %s")
    public void stoppingServer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10924, value="Server %s is not in the expected %s state: %s")
    public void unexpectedServerState(String var1, ServerState var2, ServerState var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10925, value="Unregistered remote slave host \"%s\"")
    public void unregisteredRemoteSlaveHost(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10926, value="Unregistering server %s")
    public void unregisteringServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10927, value="Registered at domain controller")
    public void registeredAtRemoteHostController();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10928, value="Unregistered at domain controller")
    public void unregisteredAtRemoteHostController();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10929, value="Connection to remote host \"%s\" closed unexpectedly")
    public void lostConnectionToRemoteHost(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10930, value="Cannot load the domain model using using --backup")
    public void invalidRemoteBackupPersisterState();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10931, value="Cannot store the domain model using using --cached-dc")
    public void invalidCachedPersisterState();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10932, value="Caught exception during boot")
    public void caughtExceptionDuringBoot(@Cause Exception var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=10933, value="Host Controller boot has failed in an unrecoverable manner; exiting. See previous messages for details.")
    public void unsuccessfulBoot();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10934, value="Installation of the domain-wide configuration has failed. Because the running mode of this Host Controller is ADMIN_ONLY boot has been allowed to proceed. If ADMIN_ONLY mode were not in effect the process would be terminated due to a critical boot failure.")
    public void reportAdminOnlyDomainXmlFailure();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10935, value="Graceful shutdown of the handler used for messages from other Host Controllers did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownTimedOut(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10936, value="The master host controller has been restarted. Re-registering this slave host controller with the new master.")
    public void masterHostControllerChanged();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10937, value="The master host controller could not be reached in the last [%d] milliseconds. Re-connecting.")
    public void masterHostControllerUnreachable(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10938, value="The slave host controller \"%s\" has been restarted or is attempting to reconnect. Unregistering the current connection to this slave.")
    public void slaveHostControllerChanged(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10939, value="The slave host controller \"%s\"  could not be reached in the last [%d] milliseconds. Unregistering.")
    public void slaveHostControllerUnreachable(String var1, long var2);
}

