/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentDeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRedeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentUndeployHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.DeploymentResourceDefinition;

public class DomainDeploymentResourceDefinition
extends DeploymentResourceDefinition {
    private OperationDefinition addDefinition;

    private DomainDeploymentResourceDefinition(DeploymentResourceDefinition.DeploymentResourceParent parent, OperationDefinition addDefinition, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(parent, addHandler, removeHandler);
        this.addDefinition = addDefinition;
    }

    public static DomainDeploymentResourceDefinition createForDomainRoot(boolean isMaster, ContentRepository contentRepository, HostFileRepository fileRepository) {
        return new DomainDeploymentResourceDefinition(DeploymentResourceDefinition.DeploymentResourceParent.DOMAIN, DeploymentAttributes.DOMAIN_DEPLOYMENT_ADD_DEFINITION, isMaster ? new DeploymentAddHandler(contentRepository) : new DeploymentAddHandler(), isMaster ? DeploymentRemoveHandler.createForMaster(contentRepository) : DeploymentRemoveHandler.createForSlave((DeploymentFileRepository)fileRepository));
    }

    public static DomainDeploymentResourceDefinition createForServerGroup(ContentRepository contentRepository, HostFileRepository fileRepository) {
        return new DomainDeploymentResourceDefinition(DeploymentResourceDefinition.DeploymentResourceParent.SERVER_GROUP, DeploymentAttributes.SERVER_GROUP_DEPLOYMENT_ADD_DEFINITION, new ServerGroupDeploymentAddHandler(fileRepository), (OperationStepHandler)ServerGroupRemoveHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.getParent() == DeploymentResourceDefinition.DeploymentResourceParent.SERVER_GROUP) {
            resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOY_DEFINITION, (OperationStepHandler)ServerGroupDeploymentDeployHandler.INSTANCE);
            resourceRegistration.registerOperationHandler(DeploymentAttributes.REDEPLOY_DEFINITION, (OperationStepHandler)ServerGroupDeploymentRedeployHandler.INSTANCE);
            resourceRegistration.registerOperationHandler(DeploymentAttributes.UNDEPLOY_DEFINITION, (OperationStepHandler)ServerGroupDeploymentUndeployHandler.INSTANCE);
        }
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(this.addDefinition, handler);
    }
}

