/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;

    public DeploymentFullReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
    }

    public DeploymentFullReplaceHandler(HostFileRepository fileRepository) {
        this.contentRepository = null;
        this.fileRepository = fileRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathElement deploymentPath;
        Resource root;
        Resource replaceNode;
        byte[] hash;
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        final String name = ((AttributeDefinition)DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.get("name")).resolveModelAttribute(context, operation).asString();
        String runtimeName = operation.hasDefined("runtime-name") ? ((AttributeDefinition)DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.get("runtime-name")).resolveModelAttribute(context, operation).asString() : name;
        ModelNode content = operation.require("content");
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            hash = contentItemNode.require("hash").asBytes();
            if (this.contentRepository != null) {
                if (!this.contentRepository.hasContent(hash)) {
                    throw AbstractDeploymentHandler.createFailureException(DomainControllerMessages.MESSAGES.noDeploymentContentWithHash(HashUtil.bytesToHexString((byte[])hash)));
                }
            } else {
                this.fileRepository.getDeploymentFiles(hash);
            }
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined((ModelNode)contentItemNode)) {
            if (this.contentRepository == null) {
                throw AbstractDeploymentHandler.createFailureException(DomainControllerMessages.MESSAGES.slaveCannotAcceptUploads());
            }
            InputStream in = DeploymentHandlerUtils.getInputStream((OperationContext)context, (ModelNode)contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw AbstractDeploymentHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode = new ModelNode();
            contentItemNode.get("hash").set(hash);
            content = new ModelNode();
            content.add(contentItemNode);
        }
        if ((replaceNode = (root = context.readResource(PathAddress.EMPTY_ADDRESS)).getChild(deploymentPath = PathElement.pathElement((String)"deployment", (String)name))) == null) {
            throw AbstractDeploymentHandler.createFailureException(DomainControllerMessages.MESSAGES.noDeploymentContentWithName(name));
        }
        Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        final ModelNode deployNode = deployment.getModel();
        final byte[] originalHash = deployNode.get("content").get(0).hasDefined("hash") ? deployNode.get("content").get(0).get("hash").asBytes() : null;
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("content").set(content);
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            for (Resource.ResourceEntry serverGroupResource : root.getChildren("server-group")) {
                Resource deploymentResource = serverGroupResource.getChild(deploymentPath);
                if (deploymentResource == null) continue;
                deploymentResource.getModel().get("runtime-name").set(runtimeName);
            }
        }
        DeploymentFullReplaceHandler.removeContentAdditions(replaceNode.getModel().require("content"));
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    byte[] newHash;
                    if (originalHash != null && DeploymentFullReplaceHandler.this.contentRepository != null && deployNode.get("content").get(0).hasDefined("hash") && !Arrays.equals(originalHash, newHash = deployNode.get("content").get(0).get("hash").asBytes())) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(originalHash, (Object)name);
                    }
                } else if (DeploymentFullReplaceHandler.this.contentRepository != null && operation.get("content").get(0).hasDefined("hash")) {
                    byte[] newHash = operation.get("content").get(0).get("hash").asBytes();
                    DeploymentFullReplaceHandler.this.contentRepository.removeContent(newHash, (Object)name);
                }
            }
        });
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, AbstractDeploymentHandler.CONTENT_ADDITION_PARAMETERS);
        }
    }
}

