/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryCallbackService;
import org.jboss.as.host.controller.ServerInventoryImpl;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.AsyncFutureTask;

class ServerInventoryService
implements Service<ServerInventory> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory"});
    private final InjectedValue<ProcessControllerConnectionService> client = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBinding = new InjectedValue();
    private final InjectedValue<ServerInventoryCallbackService> serverCallback = new InjectedValue();
    private final DomainController domainController;
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final ExtensionRegistry extensionRegistry;
    private final int port;
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final FutureServerInventory futureInventory = new FutureServerInventory();
    private ServerInventoryImpl serverInventory;

    private ServerInventoryService(DomainController domainController, HostRunningModeControl runningModeControl, HostControllerEnvironment environment, ExtensionRegistry extensionRegistry, int port) {
        this.extensionRegistry = extensionRegistry;
        this.domainController = domainController;
        this.runningModeControl = runningModeControl;
        this.environment = environment;
        this.port = port;
    }

    static Future<ServerInventory> install(ServiceTarget serviceTarget, DomainController domainController, HostRunningModeControl runningModeControl, HostControllerEnvironment environment, ExtensionRegistry extensionRegistry, String interfaceBinding, int port) {
        ServerInventoryService inventory = new ServerInventoryService(domainController, runningModeControl, environment, extensionRegistry, port);
        serviceTarget.addService(SERVICE_NAME, (Service)inventory).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, inventory.executorService).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, inventory.getClient()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceBinding}), NetworkInterfaceBinding.class, inventory.interfaceBinding).addDependency(ServerInventoryCallbackService.SERVICE_NAME, ServerInventoryCallbackService.class, inventory.serverCallback).addDependency(ManagementChannelRegistryService.SERVICE_NAME).install();
        return inventory.futureInventory;
    }

    public synchronized void start(StartContext context) throws StartException {
        HostControllerLogger.ROOT_LOGGER.debug("Starting Host Controller Server Inventory");
        try {
            ProcessControllerConnectionService processControllerConnectionService = (ProcessControllerConnectionService)this.client.getValue();
            InetSocketAddress binding = new InetSocketAddress(((NetworkInterfaceBinding)this.interfaceBinding.getValue()).getAddress(), this.port);
            this.serverInventory = new ServerInventoryImpl(this.domainController, this.environment, binding, processControllerConnectionService.getClient(), this.extensionRegistry);
            processControllerConnectionService.setServerInventory(this.serverInventory);
            ((ServerInventoryCallbackService)this.serverCallback.getValue()).setCallbackHandler(this.serverInventory.getServerCallbackHandler());
            this.futureInventory.setInventory(this.serverInventory);
        }
        catch (Exception e) {
            this.futureInventory.setFailure(e);
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(final StopContext context) {
        if (this.runningModeControl.getRestartMode() == RestartMode.SERVERS) {
            context.asynchronous();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerInventoryService.this.serverInventory.shutdown(-1, true);
                        ServerInventoryService.this.serverInventory = null;
                    }
                    finally {
                        ((ServerInventoryCallbackService)ServerInventoryService.this.serverCallback.getValue()).setCallbackHandler(null);
                        context.complete();
                    }
                }
            };
            ((ExecutorService)this.executorService.getValue()).execute(r);
        }
    }

    public synchronized ServerInventory getValue() throws IllegalStateException, IllegalArgumentException {
        ServerInventoryImpl serverInventory = this.serverInventory;
        if (serverInventory == null) {
            throw new IllegalStateException();
        }
        return serverInventory;
    }

    InjectedValue<ProcessControllerConnectionService> getClient() {
        return this.client;
    }

    private class FutureServerInventory
    extends AsyncFutureTask<ServerInventory> {
        protected FutureServerInventory() {
            super(null);
        }

        private void setInventory(ServerInventory inventory) {
            super.setResult((Object)inventory);
        }

        private void setFailure(Throwable t) {
            super.setFailed(t);
        }
    }
}

