/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.List;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;

abstract class AbstractServerGroupRolloutTask
implements Runnable {
    protected final List<ServerUpdateTask> tasks;
    protected final ServerUpdatePolicy updatePolicy;
    protected final ServerTaskExecutor executor;
    protected final ServerUpdateTask.ServerUpdateResultHandler resultHandler;

    public AbstractServerGroupRolloutTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, ServerUpdateTask.ServerUpdateResultHandler resultHandler) {
        this.tasks = tasks;
        this.updatePolicy = updatePolicy;
        this.executor = executor;
        this.resultHandler = resultHandler;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable t) {
            DomainControllerLogger.ROOT_LOGGER.debugf(t, "failed to process task %s", this.tasks.iterator().next().getOperation());
        }
    }

    protected abstract void execute();

    protected void recordPreparedOperation(ServerIdentity identity, TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation> prepared) {
        this.updatePolicy.recordServerResult(identity, prepared.getPreparedResult());
        this.executor.recordPreparedOperation(prepared);
        this.resultHandler.handleServerUpdateResult(identity, prepared.getPreparedResult());
    }

    protected void sendCancelledResponse(ServerIdentity serverId) {
        ModelNode response = new ModelNode();
        response.get("outcome").set("cancelled");
        this.resultHandler.handleServerUpdateResult(serverId, response);
    }
}

