/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.model.jvm.JVMDescriptions;
import org.jboss.dmr.ModelNode;

final class JVMOptionRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "remove-jvm-option";
    static final JVMOptionRemoveHandler INSTANCE = new JVMOptionRemoveHandler();
    private final ParameterValidator validator = new StringLengthValidator(1);

    JVMOptionRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validateParameter("jvm-option", operation.get("jvm-option"));
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode option = operation.require("jvm-option");
        if (model.hasDefined("jvm-options")) {
            ModelNode values = model.get("jvm-options").clone();
            model.get("jvm-options").setEmptyList();
            for (ModelNode value : values.asList()) {
                if (value.equals(option)) continue;
                model.get("jvm-options").add(value);
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JVMDescriptions.getOptionRemoveOperation(locale);
    }
}

