/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;

public class HostControllerRegistrationHandler
implements ManagementRequestHandlerFactory {
    private static final ModelNode READ_DOMAIN_MODEL = new ModelNode();
    private final ManagementChannelHandler handler;
    private final ModelController controller;
    private final DomainController domainController;

    public HostControllerRegistrationHandler(ManagementChannelHandler handler, ModelController controller, DomainController domainController) {
        this.handler = handler;
        this.controller = controller;
        this.domainController = domainController;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 81: {
                RegistrationContext context = new RegistrationContext();
                context.activeOperation = handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)context);
                return new RegistrationRequestHandler();
            }
            case 88: {
                return new CompleteRegistrationHandler();
            }
        }
        return handlers.resolveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendResponse(ManagementRequestContext<RegistrationContext> context, byte responseType, ModelNode response) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte((int)responseType);
            if (response != null) {
                response.writeExternal((DataOutput)output);
            }
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendFailedResponse(ManagementRequestContext<RegistrationContext> context, byte errorCode, String message) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte(34);
            output.writeByte((int)errorCode);
            output.writeUTF(message);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static {
        READ_DOMAIN_MODEL.get("operation").set("read-master-domain-model");
        READ_DOMAIN_MODEL.get("address").setEmptyList();
        READ_DOMAIN_MODEL.protect();
    }

    class RegistrationContext
    implements ModelController.OperationTransactionControl {
        private ManagementRequestContext<RegistrationContext> responseChannel;
        private ModelNode hostInfo;
        private String hostName;
        private volatile boolean failed;
        private ActiveOperation<Void, RegistrationContext> activeOperation;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final CountDownLatch completedLatch = new CountDownLatch(1);

        RegistrationContext() {
        }

        protected synchronized void initialize(String hostName, ModelNode hostInfo, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.hostName = hostName;
            this.hostInfo = hostInfo;
            this.responseChannel = responseChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            try {
                if (this.failed) {
                    transaction.rollback();
                } else {
                    this.registerHost(transaction, result);
                    if (this.failed) {
                        transaction.rollback();
                    }
                }
            }
            finally {
                this.activeOperation.getResultHandler().done(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerHost(ModelController.OperationTransaction transaction, ModelNode result) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.hostName)) {
                    this.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(this.hostName));
                    return;
                }
                try {
                    HostControllerRegistrationHandler.sendResponse(this.responseChannel, (byte)33, result);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                    return;
                }
            }
            try {
                this.completedLatch.await();
            }
            catch (InterruptedException e) {
                this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                return;
            }
            registrationContext = this;
            synchronized (registrationContext) {
                String productName;
                if (this.failed) {
                    return;
                }
                PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostName)});
                RemoteProxyController proxy = RemoteProxyController.create((ManagementChannelHandler)HostControllerRegistrationHandler.this.handler, (PathAddress)addr, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.HOST);
                try {
                    HostControllerRegistrationHandler.this.domainController.registerRemoteHost((ProxyController)proxy);
                }
                catch (SlaveRegistrationException e) {
                    this.failed(e.getErrorCode(), e.getErrorMessage());
                    return;
                }
                catch (Exception e) {
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                    return;
                }
                if (this.failed) {
                    transaction.rollback();
                    return;
                }
                transaction.commit();
                if (this.hostInfo.hasDefined("product-name")) {
                    String name = this.hostInfo.get("product-name").asString();
                    String version1 = this.hostInfo.get("product-version").asString();
                    String version2 = this.hostInfo.get("release-version").asString();
                    productName = ProductConfig.getPrettyVersionString((String)name, (String)version1, (String)version2);
                } else {
                    String version1 = this.hostInfo.get("release-version").asString();
                    String version2 = this.hostInfo.get("release-codename").asString();
                    productName = ProductConfig.getPrettyVersionString(null, (String)version1, (String)version2);
                }
                HostControllerLogger.DOMAIN_LOGGER.registeredRemoteSlaveHost(this.hostName, productName);
            }
        }

        void completeRegistration(ManagementRequestContext<RegistrationContext> responseChannel, boolean commit) {
            this.failed |= !commit;
            this.responseChannel = responseChannel;
            this.completedLatch.countDown();
        }

        void failed(SlaveRegistrationException.ErrorCode errorCode, String message) {
            this.failed(errorCode.getCode(), message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failed(byte errorCode, String message) {
            if (this.completed.compareAndSet(false, true)) {
                this.failed = true;
                try {
                    HostControllerRegistrationHandler.sendFailedResponse(this.responseChannel, errorCode, message);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                finally {
                    this.completedLatch.countDown();
                }
            }
        }

        void sendCompletedMessage() {
            if (this.completed.compareAndSet(false, true)) {
                try {
                    HostControllerRegistrationHandler.sendResponse(this.responseChannel, (byte)33, null);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
            }
        }
    }

    static class CompleteRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        CompleteRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            String message = input.readUTF();
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.completeRegistration(context, status == 33);
        }
    }

    class RegistrationRequestHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        RegistrationRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            final String hostName = input.readUTF();
            ModelNode hostInfo = new ModelNode();
            hostInfo.readExternal(input);
            final RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.initialize(hostName, hostInfo, context);
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(hostName)) {
                registration.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(hostName));
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<RegistrationContext>(){

                public void execute(ManagementRequestContext<RegistrationContext> context) throws Exception {
                    Channel channel = context.getChannel();
                    try {
                        ModelNode result = HostControllerRegistrationHandler.this.controller.execute(READ_DOMAIN_MODEL, OperationMessageHandler.logging, (ModelController.OperationTransactionControl)registration, OperationAttachments.EMPTY);
                    }
                    catch (Exception e) {
                        registration.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                        return;
                    }
                    registration.sendCompletedMessage();
                    channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(hostName)) {
                                HostControllerLogger.DOMAIN_LOGGER.lostConnectionToRemoteHost(hostName);
                            }
                            HostControllerRegistrationHandler.this.domainController.unregisterRemoteHost(hostName);
                        }
                    });
                }
            });
        }
    }
}

