/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.ProxyTask;
import org.jboss.as.domain.controller.plan.RolloutPlanController;
import org.jboss.as.domain.controller.plan.ServerOperationExecutor;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DomainRolloutStepHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final ExecutorService executorService;
    private final ModelNode providedRolloutPlan;
    private final boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();

    public DomainRolloutStepHandler(Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, DomainOperationContext domainOperationContext, ModelNode rolloutPlan, ExecutorService executorService) {
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.domainOperationContext = domainOperationContext;
        this.providedRolloutPlan = rolloutPlan;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Iterator i$;
        boolean completeRollback;
        boolean pushToServers;
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.completeStep();
            return;
        }
        boolean bl = pushToServers = !this.domainOperationContext.hasHostLevelFailures();
        if (pushToServers) {
            ModelNode ourResult = this.domainOperationContext.getCoordinatorResult();
            if (ourResult.has("failure-description")) {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator failed: %s", ourResult);
                }
                pushToServers = false;
                this.domainOperationContext.setCompleteRollback(true);
            } else {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator succeeded: %s", ourResult);
                }
                for (ModelNode hostResult : this.domainOperationContext.getHostControllerResults().values()) {
                    if (!hostResult.has("failure-description")) continue;
                    if (this.trace) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("host failed: %s", hostResult);
                    }
                    pushToServers = false;
                    this.domainOperationContext.setCompleteRollback(true);
                    break;
                }
            }
        }
        if (!pushToServers) {
            this.reportHostFailures(context, operation);
            context.completeStep();
            return;
        }
        this.domainOperationContext.setCompleteRollback(false);
        HashMap<ServerIdentity, ProxyTask> tasks = new HashMap<ServerIdentity, ProxyTask>();
        HashMap<ServerIdentity, Future<ModelNode>> futures = new HashMap<ServerIdentity, Future<ModelNode>>();
        try {
            this.pushToServers(context, tasks, futures);
            context.completeStep();
            completeRollback = this.domainOperationContext.isCompleteRollback();
            i$ = tasks.entrySet().iterator();
        }
        catch (Throwable throwable) {
            boolean completeRollback2 = this.domainOperationContext.isCompleteRollback();
            for (Map.Entry entry : tasks.entrySet()) {
                boolean rollback = completeRollback2 || this.domainOperationContext.isServerGroupRollback(((ServerIdentity)entry.getKey()).getServerGroupName());
                ((ProxyTask)entry.getValue()).finalizeTransaction(!rollback);
            }
            boolean interrupted2 = false;
            try {
                for (Map.Entry entry : futures.entrySet()) {
                    Future future = (Future)entry.getValue();
                    try {
                        ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                        this.domainOperationContext.addServerResult((ServerIdentity)entry.getKey(), finalResult);
                    }
                    catch (InterruptedException e) {
                        interrupted2 = true;
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(((ServerIdentity)entry.getKey()).getServerName(), ((ServerIdentity)entry.getKey()).getHostName());
                    }
                    catch (ExecutionException e) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), ((ServerIdentity)entry.getKey()).getServerName(), ((ServerIdentity)entry.getKey()).getHostName());
                    }
                }
                throw throwable;
            }
            finally {
                if (interrupted2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            boolean rollback = completeRollback || this.domainOperationContext.isServerGroupRollback(((ServerIdentity)entry.getKey()).getServerGroupName());
            ((ProxyTask)entry.getValue()).finalizeTransaction(!rollback);
        }
        boolean interrupted = false;
        try {
            for (Map.Entry entry : futures.entrySet()) {
                Future future = (Future)entry.getValue();
                try {
                    ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : (ModelNode)future.get();
                    this.domainOperationContext.addServerResult((ServerIdentity)entry.getKey(), finalResult);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(((ServerIdentity)entry.getKey()).getServerName(), ((ServerIdentity)entry.getKey()).getHostName());
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), ((ServerIdentity)entry.getKey()).getServerName(), ((ServerIdentity)entry.getKey()).getHostName());
                }
            }
            return;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ModelNode getCancelledResult() {
        ModelNode cancelled = new ModelNode();
        cancelled.get("outcome").set("cancelled");
        return cancelled;
    }

    private void pushToServers(final OperationContext context, final Map<ServerIdentity, ProxyTask> tasks, final Map<ServerIdentity, Future<ModelNode>> futures) throws OperationFailedException {
        Map<String, Map<ServerIdentity, ModelNode>> opsByGroup;
        final String localHostName = this.domainOperationContext.getLocalHostInfo().getLocalHostName();
        HashMap<String, ModelNode> hostResults = new HashMap<String, ModelNode>(this.domainOperationContext.getHostControllerResults());
        if (this.domainOperationContext.getCoordinatorResult().isDefined()) {
            hostResults.put(localHostName, this.domainOperationContext.getCoordinatorResult());
        }
        if ((opsByGroup = this.getOpsByGroup(hostResults)).size() > 0) {
            ModelNode rolloutPlan = this.getRolloutPlan(this.providedRolloutPlan, opsByGroup);
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan is %s", rolloutPlan);
            }
            ServerOperationExecutor operationExecutor = new ServerOperationExecutor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ModelNode executeServerOperation(ServerIdentity server, ModelNode operation) {
                    ProxyController proxy = (ProxyController)DomainRolloutStepHandler.this.hostProxies.get(server.getHostName());
                    if (proxy == null && localHostName.equals(server.getHostName()) && (proxy = (ProxyController)DomainRolloutStepHandler.this.serverProxies.get(server.getServerName())) == null) {
                        if (DomainRolloutStepHandler.this.trace) {
                            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("No proxy for %s", server);
                        }
                        return null;
                    }
                    ProxyTask task = new ProxyTask(server.getHostName(), operation, context, proxy);
                    tasks.put(server, task);
                    boolean interrupted = false;
                    Future<ModelNode> future = null;
                    ModelNode result = null;
                    try {
                        future = DomainRolloutStepHandler.this.executorService.submit(task);
                        result = task.getUncommittedResult();
                        futures.put(server, future);
                    }
                    catch (Exception e) {
                        result = new ModelNode();
                        result.get("outcome").set("failed");
                        if (e instanceof InterruptedException) {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.interruptedAwaitingResultFromServer(server));
                            interrupted = true;
                        } else {
                            result.get("failure-description").set(DomainControllerMessages.MESSAGES.exceptionAwaitingResultFromServer(server, e.getMessage()));
                        }
                        task.cancel();
                        future.cancel(true);
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    return result;
                }
            };
            RolloutPlanController rolloutPlanController = new RolloutPlanController(opsByGroup, rolloutPlan, this.domainOperationContext, operationExecutor, this.executorService);
            RolloutPlanController.Result planResult = rolloutPlanController.execute();
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan result is %s", (Object)planResult);
            }
            if (planResult == RolloutPlanController.Result.FAILED) {
                this.domainOperationContext.setCompleteRollback(true);
                context.getResult();
                context.getFailureDescription().set(DomainControllerMessages.MESSAGES.operationFailedOrRolledBack());
                this.domainOperationContext.setFailureReported(true);
            }
        }
    }

    private Map<String, Map<ServerIdentity, ModelNode>> getOpsByGroup(Map<String, ModelNode> hostResults) {
        HashMap<String, Map<ServerIdentity, ModelNode>> result = new HashMap<String, Map<ServerIdentity, ModelNode>>();
        for (Map.Entry<String, ModelNode> entry : hostResults.entrySet()) {
            ModelNode hostResult;
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("1st phase result from host %s is %s", entry.getKey(), entry.getValue());
            }
            if (!(hostResult = entry.getValue().get("result")).hasDefined("server-operations")) continue;
            String host = entry.getKey();
            for (ModelNode item : hostResult.get("server-operations").asList()) {
                ModelNode op = this.translateDomainMappedOperation(item.require("operation"));
                for (Property prop : item.require("servers").asPropertyList()) {
                    String group = prop.getValue().asString();
                    HashMap<ServerIdentity, ModelNode> groupMap = (HashMap<ServerIdentity, ModelNode>)result.get(group);
                    if (groupMap == null) {
                        groupMap = new HashMap<ServerIdentity, ModelNode>();
                        result.put(group, groupMap);
                    }
                    groupMap.put(new ServerIdentity(host, group, prop.getName()), op);
                }
            }
        }
        return result;
    }

    private ModelNode translateDomainMappedOperation(ModelNode domainMappedOperation) {
        if (domainMappedOperation.hasDefined("operation")) {
            return domainMappedOperation;
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        ModelNode steps = composite.get("steps").setEmptyList();
        for (Property property : domainMappedOperation.asPropertyList()) {
            steps.add(this.translateDomainMappedOperation(property.getValue()));
        }
        return composite;
    }

    private ModelNode getRolloutPlan(ModelNode rolloutPlan, Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) throws OperationFailedException {
        if (rolloutPlan == null || !rolloutPlan.isDefined()) {
            rolloutPlan = this.getDefaultRolloutPlan(opsByGroup);
        } else {
            HashSet<String> found = new HashSet<String>();
            if (rolloutPlan.hasDefined("in-series")) {
                for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                    if (series.hasDefined("concurrent-groups")) {
                        for (Property prop : series.get("concurrent-groups").asPropertyList()) {
                            this.validateServerGroupPlan(found, prop);
                        }
                        continue;
                    }
                    if (series.hasDefined("server-group")) {
                        Property prop = series.get("server-group").asProperty();
                        this.validateServerGroupPlan(found, prop);
                        continue;
                    }
                    throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlan(series, "in-series")));
                }
            }
            HashSet<String> groups = new HashSet<String>(opsByGroup.keySet());
            groups.removeAll(found);
            if (!groups.isEmpty()) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlan(groups)));
            }
        }
        return rolloutPlan;
    }

    private void validateServerGroupPlan(Set<String> found, Property prop) throws OperationFailedException {
        int max;
        if (!found.add(prop.getName())) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanGroupAlreadyExists(prop.getName())));
        }
        ModelNode plan = prop.getValue();
        if (plan.hasDefined("max-failure-percentage")) {
            if (plan.has("max-failed-servers")) {
                plan.remove("max-failed-servers");
            }
            if ((max = plan.get("max-failure-percentage").asInt()) < 0 || max > 100) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanRange(prop.getName(), "max-failure-percentage", max)));
            }
        }
        if (plan.hasDefined("max-failed-servers") && (max = plan.get("max-failed-servers").asInt()) < 0) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanLess(prop.getName(), "max-failed-servers", max)));
        }
    }

    private ModelNode getDefaultRolloutPlan(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) {
        ModelNode result = new ModelNode();
        if (opsByGroup.size() > 0) {
            ModelNode groups = result.get("in-series").add().get("concurrent-groups");
            ModelNode groupPlan = new ModelNode();
            groupPlan.get("rolling-to-servers").set(false);
            groupPlan.get("max-failed-servers").set(0);
            for (String group : opsByGroup.keySet()) {
                groups.add(group, groupPlan);
            }
            result.get("rollback-across-groups").set(true);
        }
        return result;
    }

    private void reportHostFailures(OperationContext context, ModelNode operation) {
        boolean isDomain = this.isDomainOperation(operation);
        if (!this.collectDomainFailure(context, isDomain)) {
            this.collectHostFailures(context, isDomain);
        }
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        ModelNode domainFailure = null;
        if (isDomain && coordinator != null && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            this.domainOperationContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.domainOperationContext.getHostControllerResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        if (!isDomain && coordinator != null && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            this.domainOperationContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }
}

