/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HostControllerBootstrap {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"host", "controller"});
    static final int DEFAULT_POOL_SIZE = 20;
    private final ServiceContainer serviceContainer = ServiceContainer.Factory.create((String)"host-controller");
    private final HostControllerEnvironment environment;
    private final byte[] authCode;

    public HostControllerBootstrap(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    public void start() throws Exception {
        ServiceContainer serviceTarget = this.serviceContainer;
        ProcessControllerConnectionService processControllerClient = new ProcessControllerConnectionService(this.environment, this.authCode);
        serviceTarget.addService(ProcessControllerConnectionService.SERVICE_NAME, (Service)processControllerClient).install();
        ServiceName threadFactoryServiceName = SERVICE_NAME_BASE.append(new String[]{"thread-factory"});
        ServiceName executorServiceName = SERVICE_NAME_BASE.append(new String[]{"executor"});
        serviceTarget.addService(threadFactoryServiceName, (Service)new ThreadFactoryService()).install();
        HostControllerExecutorService executorService = new HostControllerExecutorService();
        serviceTarget.addService(executorServiceName, (Service)executorService).addDependency(threadFactoryServiceName, ThreadFactory.class, executorService.threadFactoryValue).install();
        AbsolutePathService.addService((String)"jboss.home.dir", (String)this.environment.getHomeDir().getAbsolutePath(), (ServiceTarget)serviceTarget);
        AbsolutePathService.addService((String)"jboss.domain.config.dir", (String)this.environment.getDomainConfigurationDir().getAbsolutePath(), (ServiceTarget)serviceTarget);
        DomainModelControllerService.addService((ServiceTarget)serviceTarget, this.environment, new ControlledProcessState(false));
    }

    static final class HostControllerExecutorService
    implements Service<Executor> {
        final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
        private ScheduledExecutorService executorService;

        HostControllerExecutorService() {
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = Executors.newScheduledThreadPool(20, (ThreadFactory)this.threadFactoryValue.getValue());
        }

        public synchronized void stop(StopContext context) {
            this.executorService.shutdown();
        }

        public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
            return this.executorService;
        }
    }
}

