/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.domain.controller.descriptions.DomainDescriptionProviders;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.HostControllerBootstrap;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.LocalFileRepository;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.NewServerInventoryService;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerService;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandlerFactoryService;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.JBossThreadFactory;

public class DomainModelControllerService
extends AbstractControllerService
implements DomainController,
UnregisteredHostChannelRegistry {
    public static final ServiceName SERVICE_NAME = HostControllerBootstrap.SERVICE_NAME_BASE.append(new String[]{"model", "controller"});
    private final HostControllerConfigurationPersister configurationPersister;
    private final HostControllerEnvironment environment;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final FileRepository localFileRepository;
    private final RemoteDomainConnectionService.RemoteFileRepository remoteFileRepository;
    private final InjectedValue<ExecutorService> injectedExecutorService = new InjectedValue();
    private final InjectedValue<ProcessControllerConnectionService> injectedProcessControllerConnection = new InjectedValue();
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final PrepareStepHandler prepareStepHandler;
    private ManagementResourceRegistration modelNodeRegistration;
    private volatile MasterDomainControllerClient masterDomainControllerClient;
    private final Map<String, ManagementChannel> unregisteredHostChannels = new HashMap<String, ManagementChannel>();
    private final Map<String, UnregisteredHostChannelRegistry.ProxyCreatedCallback> proxyCreatedCallbacks = new HashMap<String, UnregisteredHostChannelRegistry.ProxyCreatedCallback>();
    private final ExecutorService proxyExecutor = Executors.newCachedThreadPool();
    private volatile ServerInventory serverInventory;

    public static ServiceController<ModelController> addService(ServiceTarget serviceTarget, HostControllerEnvironment environment, ControlledProcessState processState) {
        ConcurrentHashMap<String, ProxyController> hostProxies = new ConcurrentHashMap<String, ProxyController>();
        ConcurrentHashMap<String, ProxyController> serverProxies = new ConcurrentHashMap<String, ProxyController>();
        LocalHostControllerInfoImpl hostControllerInfo = new LocalHostControllerInfoImpl(processState);
        PrepareStepHandler prepareStepHandler = new PrepareStepHandler((LocalHostControllerInfo)hostControllerInfo, hostProxies, serverProxies);
        DomainModelControllerService service = new DomainModelControllerService(environment, processState, hostControllerInfo, new HostControllerConfigurationPersister(environment, hostControllerInfo), hostProxies, serverProxies, prepareStepHandler);
        return serviceTarget.addService(SERVICE_NAME, (Service)service).addDependency(HostControllerBootstrap.SERVICE_NAME_BASE.append(new String[]{"executor"}), ExecutorService.class, service.injectedExecutorService).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, service.injectedProcessControllerConnection).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private DomainModelControllerService(HostControllerEnvironment environment, ControlledProcessState processState, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister configurationPersister, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, PrepareStepHandler prepareStepHandler) {
        super(OperationContext.Type.HOST, (ConfigurationPersister)configurationPersister, processState, DomainDescriptionProviders.ROOT_PROVIDER, (OperationStepHandler)prepareStepHandler);
        this.configurationPersister = configurationPersister;
        this.environment = environment;
        this.hostControllerInfo = hostControllerInfo;
        this.localFileRepository = new LocalFileRepository(environment);
        this.remoteFileRepository = new RemoteDomainConnectionService.RemoteFileRepository(this.localFileRepository);
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.prepareStepHandler = prepareStepHandler;
    }

    public LocalHostControllerInfo getLocalHostInfo() {
        return this.hostControllerInfo;
    }

    public void registerRemoteHost(ProxyController hostControllerClient) {
        if (!this.hostControllerInfo.isMasterDomainController()) {
            throw new UnsupportedOperationException("Registration of remote hosts is not supported on slave host controllers");
        }
        PathAddress pa = hostControllerClient.getProxyNodeAddress();
        PathElement pe = pa.getElement(0);
        ProxyController existingController = this.modelNodeRegistration.getProxyController(pa);
        if ((existingController != null || this.hostControllerInfo.getLocalHostName().equals(pe.getValue())) && existingController instanceof RemoteProxyController) {
            if (((RemoteProxyController)existingController).ping(3000L)) {
                throw new IllegalArgumentException("There is already a registered host named '" + pe.getValue() + "'");
            }
            this.unregisterRemoteHost(pe.getValue());
        }
        this.modelNodeRegistration.registerProxyController(pe, hostControllerClient);
        this.hostProxies.put(pe.getValue(), hostControllerClient);
        Logger.getLogger((String)"org.jboss.domain").info((Object)("Registered remote slave host " + pe.getValue()));
    }

    public void unregisterRemoteHost(String id) {
        if (this.hostProxies.remove(id) != null) {
            Logger.getLogger((String)"org.jboss.domain").info((Object)("Unregistered remote slave host " + id));
        }
        this.modelNodeRegistration.unregisterProxyController(PathElement.pathElement((String)"host", (String)id));
    }

    public void registerRunningServer(ProxyController serverControllerClient) {
        PathAddress pa = serverControllerClient.getProxyNodeAddress();
        PathElement pe = pa.getElement(1);
        if (this.modelNodeRegistration.getProxyController(pa) != null) {
            throw new IllegalArgumentException("There is already a registered server named '" + pe.getValue() + "'");
        }
        Logger.getLogger((String)"org.jboss.host.controller").info((Object)("Registering server " + pe.getValue()));
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host")}));
        hostRegistration.registerProxyController(pe, serverControllerClient);
        this.serverProxies.put(pe.getValue(), serverControllerClient);
    }

    public void unregisterRunningServer(String serverName) {
        PathAddress pa = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostControllerInfo.getLocalHostName())});
        PathElement pe = PathElement.pathElement((String)"server", (String)serverName);
        Logger.getLogger((String)"org.jboss.host.controller").info((Object)("Unregistering server " + serverName));
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(pa);
        hostRegistration.unregisterProxyController(pe);
        this.serverProxies.remove(serverName);
    }

    public ModelNode getProfileOperations(String profileName) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)}).toModelNode());
        ModelNode rsp = this.getValue().execute(operation, null, null, null);
        if (!rsp.hasDefined("outcome") || !"success".equals(rsp.get("outcome").asString())) {
            ModelNode msgNode = rsp.get("failure-description");
            String msg = msgNode.isDefined() ? msgNode.toString() : "Failed to retrieve profile operations from domain controller";
            throw new RuntimeException(msg);
        }
        return rsp.require("result");
    }

    public FileRepository getFileRepository() {
        return this.localFileRepository;
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        DomainModelUtil.updateCoreModel((ModelNode)rootResource.getModel());
        HostModelUtil.createHostRegistry(rootRegistration, this.configurationPersister, this.environment, this.localFileRepository, this.hostControllerInfo, new DelegatingServerInventory(), this.remoteFileRepository, this, this);
        this.modelNodeRegistration = rootRegistration;
    }

    public void start(StartContext context) throws StartException {
        this.prepareStepHandler.setExecutorService((ExecutorService)this.injectedExecutorService.getValue());
        super.start(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        try {
            super.boot(this.configurationPersister.load());
            NetworkInterfaceBinding nativeManagementInterfaceBinding = this.getNativeManagementNetworkInterfaceBinding();
            Future<ServerInventory> inventoryFuture = NewServerInventoryService.install(serviceTarget, this, this.environment, nativeManagementInterfaceBinding, this.hostControllerInfo.getNativeManagementPort());
            RemotingServices.installRemotingEndpoint((ServiceTarget)serviceTarget);
            if (!this.hostControllerInfo.isMasterDomainController()) {
                this.serverInventory = this.getFuture(inventoryFuture);
                Future<MasterDomainControllerClient> clientFuture = RemoteDomainConnectionService.install(serviceTarget, this.getValue(), this.hostControllerInfo.getLocalHostName(), this.hostControllerInfo.getRemoteDomainControllerHost(), this.hostControllerInfo.getRemoteDomainControllertPort(), this.hostControllerInfo.getRemoteDomainControllerSecurityRealm(), this.remoteFileRepository);
                this.masterDomainControllerClient = this.getFuture(clientFuture);
                this.masterDomainControllerClient.register();
            } else {
                ExtensibleConfigurationPersister domainPersister = this.configurationPersister.getDomainPersister();
                super.boot(domainPersister.load());
                RemotingServices.installChannelServices((ServiceTarget)serviceTarget, (AbstractModelControllerOperationHandlerFactoryService)new MasterDomainControllerOperationHandlerService(this, this), (ServiceName)SERVICE_NAME, (String)"domain", null, null);
                this.serverInventory = this.getFuture(inventoryFuture);
            }
            ServiceName realmSvcName = null;
            String nativeSecurityRealm = this.hostControllerInfo.getNativeManagementSecurityRealm();
            if (nativeSecurityRealm != null) {
                realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{nativeSecurityRealm});
            }
            RemotingServices.installDomainConnectorServices((ServiceTarget)serviceTarget, (NetworkInterfaceBinding)nativeManagementInterfaceBinding, (int)this.hostControllerInfo.getNativeManagementPort(), (ServiceName)realmSvcName, null, null);
            ServerToHostOperationHandlerFactoryService.install(serviceTarget, NewServerInventoryService.SERVICE_NAME);
            RemotingServices.installChannelOpenListenerService((ServiceTarget)serviceTarget, (String)"server", (ServiceName)ServerToHostOperationHandlerFactoryService.SERVICE_NAME, null, null);
            RemotingServices.installChannelServices((ServiceTarget)serviceTarget, (AbstractModelControllerOperationHandlerFactoryService)new ModelControllerClientOperationHandlerFactoryService(), (ServiceName)SERVICE_NAME, (String)"management", null, null);
            if (this.hostControllerInfo.getHttpManagementInterface() != null) {
                this.installHttpManagementServices(serviceTarget);
            }
            this.startServers();
        }
        finally {
            this.finishBoot();
        }
    }

    private void installHttpManagementServices(ServiceTarget serviceTarget) {
        String interfaceName = this.hostControllerInfo.getHttpManagementInterface();
        int port = this.hostControllerInfo.getHttpManagementPort();
        int securePort = this.hostControllerInfo.getHttpManagementSecurePort();
        String securityRealm = this.hostControllerInfo.getHttpManagementSecurityRealm();
        StringBuilder sb = new StringBuilder();
        sb.append("creating http management service using network interface (").append(interfaceName).append(")");
        if (port > -1) {
            sb.append(" port (").append(port).append(")");
        }
        if (securePort > -1) {
            sb.append(" securePort (").append(securePort).append(")");
        }
        Logger.getLogger((String)"org.jboss.as").info((Object)sb.toString());
        JBossThreadFactory httpMgmtThreads = new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        HttpManagementService service = new HttpManagementService();
        ServiceBuilder builder = serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(SERVICE_NAME, ModelController.class, service.getModelControllerInjector()).addInjection((Injector)service.getTempDirInjector(), (Object)this.environment.getDomainTempDir().getAbsolutePath()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)httpMgmtThreads));
        if (securityRealm != null) {
            builder.addDependency(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), SecurityRealmService.class, (Injector)service.getSecurityRealmInjector());
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm defined for http management service, all access will be unrestricted.");
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private NetworkInterfaceBinding getNativeManagementNetworkInterfaceBinding() {
        try {
            return this.hostControllerInfo.getNetworkInterfaceBinding(this.hostControllerInfo.getNativeManagementInterface());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void startServers() {
        ModelNode addr = new ModelNode();
        addr.add("host", this.hostControllerInfo.getLocalHostName());
        ModelNode op = Util.getEmptyOperation((String)"start-servers", (ModelNode)addr);
        this.getValue().execute(op, null, null, null);
    }

    public void stop(StopContext context) {
        this.serverInventory = null;
        super.stop(context);
    }

    public void stopLocalHost() {
        ProcessControllerClient client = ((ProcessControllerConnectionService)this.injectedProcessControllerConnection.getValue()).getClient();
        try {
            client.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing down host", e);
        }
    }

    public synchronized void registerChannel(final String hostName, ManagementChannel channel, UnregisteredHostChannelRegistry.ProxyCreatedCallback callback) {
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)hostName)});
        if (this.unregisteredHostChannels.containsKey(hostName)) {
            throw new IllegalArgumentException("Already have a connection for host " + hostName);
        }
        this.unregisteredHostChannels.put(hostName, channel);
        this.proxyCreatedCallbacks.put(hostName, callback);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                DomainModelControllerService.this.unregisteredHostChannels.remove(hostName);
                DomainModelControllerService.this.proxyCreatedCallbacks.remove(hostName);
            }
        });
    }

    public synchronized ProxyController popChannelAndCreateProxy(final String hostName) {
        ManagementChannel channel = this.unregisteredHostChannels.remove(hostName);
        if (channel == null) {
            throw new IllegalArgumentException("No channel for host " + hostName);
        }
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                DomainModelControllerService.this.unregisterRemoteHost(hostName);
            }
        });
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)hostName)});
        RemoteProxyController proxy = RemoteProxyController.create((ExecutorService)this.proxyExecutor, (PathAddress)addr, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.HOST, (ManagementChannel)channel);
        UnregisteredHostChannelRegistry.ProxyCreatedCallback callback = this.proxyCreatedCallbacks.remove(hostName);
        if (callback != null) {
            callback.proxyCreated((ManagementOperationHandler)proxy);
        }
        return proxy;
    }

    private class DelegatingServerInventory
    implements ServerInventory {
        private DelegatingServerInventory() {
        }

        @Override
        public void serverRegistered(String serverProcessName, ManagementChannel channel, ManagedServerLifecycleCallback.ProxyCreatedCallback callback) {
            DomainModelControllerService.this.serverInventory.serverRegistered(serverProcessName, channel, callback);
        }

        @Override
        public void serverStartFailed(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverStartFailed(serverProcessName);
        }

        @Override
        public void serverStopped(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverStopped(serverProcessName);
        }

        @Override
        public String getServerProcessName(String serverName) {
            return DomainModelControllerService.this.serverInventory.getServerProcessName(serverName);
        }

        @Override
        public void processInventory(Map<String, ProcessInfo> processInfos) {
            DomainModelControllerService.this.serverInventory.processInventory(processInfos);
        }

        @Override
        public Map<String, ProcessInfo> determineRunningProcesses() {
            return DomainModelControllerService.this.serverInventory.determineRunningProcesses();
        }

        @Override
        public ServerStatus determineServerStatus(String serverName) {
            return DomainModelControllerService.this.serverInventory.determineServerStatus(serverName);
        }

        public int hashCode() {
            return DomainModelControllerService.this.serverInventory.hashCode();
        }

        @Override
        public ServerStatus startServer(String serverName, ModelNode domainModel) {
            return DomainModelControllerService.this.serverInventory.startServer(serverName, domainModel);
        }

        @Override
        public void reconnectServer(String serverName, ModelNode domainModel, boolean running) {
            DomainModelControllerService.this.serverInventory.reconnectServer(serverName, domainModel, running);
        }

        @Override
        public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
            return DomainModelControllerService.this.serverInventory.restartServer(serverName, gracefulTimeout, domainModel);
        }

        @Override
        public ServerStatus stopServer(String serverName, int gracefulTimeout) {
            return DomainModelControllerService.this.serverInventory.stopServer(serverName, gracefulTimeout);
        }

        @Override
        public CallbackHandler getServerCallbackHandler() {
            return DomainModelControllerService.this.serverInventory.getServerCallbackHandler();
        }

        public boolean equals(Object obj) {
            return DomainModelControllerService.this.serverInventory.equals(obj);
        }

        public String toString() {
            return DomainModelControllerService.this.serverInventory.toString();
        }

        @Override
        public void stopServers(int gracefulTimeout) {
            DomainModelControllerService.this.serverInventory.stopServers(gracefulTimeout);
        }
    }
}

