/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class ServerStopHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "stop";
    private final ServerInventory serverInventory;

    public static ModelNode getStopServerOperation(String serverName) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)new ModelNode());
        op.get("name").set(serverName);
        return op;
    }

    public ServerStopHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServerStatus status = ServerStopHandler.this.serverInventory.stopServer(serverName, -1);
                context.getResult().set(status.toString());
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getStopServerOperation(locale);
    }
}

