/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.ModelCombiner;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;

public class ServerInventoryImpl
implements ServerInventory {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private final Map<String, ManagedServer> servers = Collections.synchronizedMap(new HashMap());
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final InetSocketAddress managementAddress;
    private final DomainController domainController;
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;

    ServerInventoryImpl(DomainController domainController, HostControllerEnvironment environment, InetSocketAddress managementAddress, ProcessControllerClient processControllerClient) {
        this.domainController = domainController;
        this.environment = environment;
        this.managementAddress = managementAddress;
        this.processControllerClient = processControllerClient;
    }

    @Override
    public String getServerProcessName(String serverName) {
        return ManagedServer.getServerProcessName(serverName);
    }

    public String getProcessServerName(String processName) {
        return ManagedServer.getServerName(processName);
    }

    @Override
    public synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not get the server inventory in 30 seconds");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.processInfos;
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    @Override
    public ServerStatus determineServerStatus(String serverName) {
        ServerStatus status;
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer client = this.servers.get(processName);
        if (client == null) {
            status = ServerStatus.STOPPED;
        } else {
            switch (client.getState()) {
                case AVAILABLE: 
                case BOOTING: 
                case STARTING: {
                    status = ServerStatus.STARTING;
                    break;
                }
                case FAILED: 
                case MAX_FAILED: {
                    status = ServerStatus.FAILED;
                    break;
                }
                case STARTED: {
                    status = ServerStatus.STARTED;
                    break;
                }
                case STOPPING: {
                    status = ServerStatus.STOPPING;
                    break;
                }
                case STOPPED: {
                    status = ServerStatus.STOPPED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + client.getState());
                }
            }
        }
        return status;
    }

    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            log.warnf("Existing server [%s] with state: %s", (Object)processName, (Object)existing.getState());
            return this.determineServerStatus(serverName);
        }
        log.infof("Starting server %s", (Object)serverName);
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        this.servers.put(processName, server);
        try {
            server.createServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to create server process %s", (Object)serverName);
        }
        try {
            server.startServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to start server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void reconnectServer(String serverName, ModelNode domainModel, boolean running) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            log.warnf("existing server [%s] with state: %s", (Object)processName, (Object)existing.getState());
        }
        log.info((Object)("Reconnecting server " + serverName));
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        this.servers.put(processName, server);
        if (running) {
            try {
                server.reconnectServerProcess(this.environment.getHostControllerPort());
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Failed to send reconnect message to server %s", (Object)serverName);
            }
        }
    }

    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
        ServerStatus status;
        this.stopServer(serverName, gracefulTimeout);
        for (int i = 0; i < 50 && (status = this.determineServerStatus(serverName)) == ServerStatus.STOPPING; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.startServer(serverName, domainModel);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        log.info((Object)("stopping server " + serverName));
        String processName = ManagedServer.getServerProcessName(serverName);
        try {
            ManagedServer server = this.servers.get(processName);
            if (server != null) {
                server.setState(ServerState.STOPPING);
                if (gracefulTimeout > -1) {
                    log.warnf("Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.", (Object)serverName);
                    server.stopServerProcess();
                    server.removeServerProcess();
                } else {
                    server.stopServerProcess();
                    server.removeServerProcess();
                }
            }
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to stop server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void serverRegistered(final String serverProcessName, ManagementChannel channel, ManagedServerLifecycleCallback.ProxyCreatedCallback callback) {
        try {
            ManagedServer server = this.servers.get(serverProcessName);
            if (server == null) {
                log.errorf("No server called %s available", (Object)serverProcessName);
                return;
            }
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    ServerInventoryImpl.this.domainController.unregisterRunningServer(serverProcessName);
                }
            });
            server.setServerManagementChannel(channel);
            if (!this.environment.isRestart()) {
                this.checkState(server, ServerState.STARTING);
            }
            server.setState(ServerState.STARTED);
            PathElement element = PathElement.pathElement((String)"server", (String)server.getServerName());
            RemoteProxyController serverController = RemoteProxyController.create((ExecutorService)Executors.newCachedThreadPool(), (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.domainController.getLocalHostInfo().getLocalHostName()), element}), (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.SERVER, (ManagementChannel)channel);
            if (callback != null && serverController instanceof ManagementOperationHandler) {
                callback.proxyOperationHandlerCreated((ManagementOperationHandler)serverController);
            }
            this.domainController.registerRunningServer((ProxyController)serverController);
            server.resetRespawnCount();
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Could not start server %s", (Object)serverProcessName);
        }
    }

    @Override
    public void serverStartFailed(String serverProcessName) {
        ManagedServer server = this.servers.get(serverProcessName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)serverProcessName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.FAILED);
    }

    @Override
    public void serverStopped(String serverProcessName) {
        ManagedServer server = this.servers.get(serverProcessName);
        if (server == null) {
            log.errorf("No server called %s exists for stop", (Object)serverProcessName);
            return;
        }
        this.domainController.unregisterRunningServer(server.getServerName());
        if (server.getState() != ServerState.STOPPING) {
            try {
                if (server.incrementAndGetRespawnCount() < 10) {
                    server.startServerProcess();
                    return;
                }
                server.setState(ServerState.MAX_FAILED);
            }
            catch (IOException e) {
                log.error((Object)("Failed to start server " + serverProcessName), (Throwable)e);
            }
        }
        this.servers.remove(serverProcessName);
    }

    @Override
    public void stopServers(int gracefulTimeout) {
        Map<String, ProcessInfo> processInfoMap = this.determineRunningProcesses();
        for (String serverProcessName : processInfoMap.keySet()) {
            if (!ManagedServer.isServerProcess(serverProcessName)) continue;
            String serverName = ManagedServer.getServerName(serverProcessName);
            this.stopServer(serverName, gracefulTimeout);
        }
    }

    private void checkState(ManagedServer server, ServerState expected) {
        ServerState state = server.getState();
        if (state != expected) {
            log.warnf("Server %s is not in the expected %s state: %s", (Object)server.getServerProcessName(), (Object)expected, (Object)state);
        }
    }

    private ManagedServer createManagedServer(String serverName, ModelNode domainModel) {
        ModelNode hostModel = domainModel.require("host").require(this.domainController.getLocalHostInfo().getLocalHostName());
        ModelCombiner combiner = new ModelCombiner(serverName, domainModel, hostModel, this.domainController, this.environment);
        return new ManagedServer(serverName, this.processControllerClient, this.managementAddress, combiner);
    }

    @Override
    public CallbackHandler getServerCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                ManagedServer server = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        String userName = nameCallback.getDefaultName();
                        server = (ManagedServer)ServerInventoryImpl.this.servers.get(ManagedServer.getServerProcessName(userName));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof RealmCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
                if (server == null) {
                    return;
                }
                for (Callback current : toRespondTo) {
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    if (!(current instanceof PasswordCallback)) continue;
                    String password = new String(server.getAuthKey());
                    ((PasswordCallback)current).setPassword(password.toCharArray());
                }
            }
        };
    }
}

