/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.host.controller.HostController;
import org.jboss.dmr.ModelNode;

public class ServerStatusHandler
implements ModelQueryOperationHandler {
    public static final String ATTRIBUTE_NAME = "status";
    private final HostController hostController;

    public ServerStatusHandler(HostController hostController) {
        this.hostController = hostController;
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        String serverName = element.getValue();
        ModelNode subModel = context.getSubModel();
        boolean isStart = subModel.hasDefined("auto-start") ? subModel.get("auto-start").asBoolean() : true;
        ServerStatus status = this.hostController.getServerStatus(serverName);
        if (status == ServerStatus.STOPPED) {
            ServerStatus serverStatus = status = isStart ? status : ServerStatus.DISABLED;
        }
        if (status != null) {
            resultHandler.handleResultFragment(Util.NO_LOCATION, new ModelNode().set(status.toString()));
            resultHandler.handleResultComplete();
        } else {
            resultHandler.handleFailed(new ModelNode().set("Failed to get server status"));
        }
        return new BasicOperationResult();
    }
}

