/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.ControllerResource;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.remote.ModelControllerClientToModelControllerAdapter;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.host.controller.mgmt.SimpleFuture;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.threads.JBossThreadFactory;

class RemoteDomainControllerSlaveClient
implements DomainControllerSlaveClient {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private static final int CONNECTION_TIMEOUT = 5000;
    private final ModelController delegate;
    private final String hostId;
    private final InetAddress slaveAddress;
    private final int slavePort;
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("RemoteDomainConnection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final ExecutorService executorService = Executors.newCachedThreadPool(this.threadFactory);

    public RemoteDomainControllerSlaveClient(String hostId, InetAddress slaveAddress, int slavePort) {
        this.hostId = hostId;
        this.slaveAddress = slaveAddress;
        this.slavePort = slavePort;
        this.delegate = new ModelControllerClientToModelControllerAdapter(slaveAddress, slavePort);
    }

    public OperationResult execute(Operation operation, ResultHandler handler) {
        return this.delegate.execute(operation, handler);
    }

    public ModelNode execute(Operation operation) throws CancellationException {
        return this.delegate.execute(operation);
    }

    public ModelNode execute(Operation operation, ControllerTransactionContext transaction) throws CancellationException {
        if (operation == null) {
            throw new IllegalArgumentException("Null operation");
        }
        try {
            return (ModelNode)new ExecuteSynchronousTransactionalRequest(operation, transaction).executeForResult(this.getConnectionStrategy());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw new CancellationException(e.getCause().getMessage());
            }
            throw new RuntimeException("Failed to execute operation ", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute operation ", e);
        }
    }

    public OperationResult execute(final Operation operation, final ResultHandler handler, final ControllerTransactionContext transaction) {
        if (operation == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (transaction == null) {
            throw new IllegalArgumentException("Null transaction");
        }
        final AsynchronousOperation result = new AsynchronousOperation();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Future f = new ExecuteAsyncTransactionalRequest(result, operation, handler, transaction).execute(RemoteDomainControllerSlaveClient.this.getConnectionStrategy());
                    while (true) {
                        try {
                            f.get(500L, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            if (!RemoteDomainControllerSlaveClient.this.executorService.isShutdown()) continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute operation ", e);
                }
            }
        });
        return new OperationResult(){

            public Cancellable getCancellable() {
                return result;
            }

            public ModelNode getCompensatingOperation() {
                return result.getCompensatingOperation();
            }
        };
    }

    public String getId() {
        return this.hostId;
    }

    public boolean isActive() {
        try {
            return (Boolean)new IsActiveRequest().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            return false;
        }
    }

    private ModelNode readNode(InputStream in) throws IOException {
        ModelNode node = new ModelNode();
        node.readExternal(in);
        return node;
    }

    private ManagementRequestConnectionStrategy getConnectionStrategy() {
        return new ManagementRequestConnectionStrategy.EstablishConnectingStrategy(this.slaveAddress, this.slavePort, 5000L, this.executorService, this.threadFactory);
    }

    private class IsActiveRequest
    extends ModelControllerRequest<Boolean> {
        private IsActiveRequest() {
        }

        public final byte getRequestCode() {
            return 87;
        }

        protected final byte getResponseCode() {
            return 88;
        }

        protected Boolean receiveResponse(InputStream input) throws IOException {
            return true;
        }
    }

    private class CancelAsynchronousOperationRequest
    extends ModelControllerRequest<Boolean> {
        private final int asynchronousId;

        CancelAsynchronousOperationRequest(int asynchronousId) {
            this.asynchronousId = asynchronousId;
        }

        protected byte getRequestCode() {
            return 73;
        }

        protected byte getResponseCode() {
            return 80;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(102);
            StreamUtils.writeInt((OutputStream)output, (int)this.asynchronousId);
        }

        protected Boolean receiveResponse(InputStream input) throws IOException {
            return StreamUtils.readBoolean((InputStream)input);
        }
    }

    private class ControllerResourceProxy
    implements ControllerResource {
        private final ModelNode transactionId;

        ControllerResourceProxy(ModelNode transactionId) {
            this.transactionId = transactionId;
        }

        public void commit() {
            try {
                new CommitTransactionRequest(this.transactionId).executeForResult(RemoteDomainControllerSlaveClient.this.getConnectionStrategy());
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Failed committing management transaction %s on host %s", (Object)this.transactionId, (Object)RemoteDomainControllerSlaveClient.this.hostId);
            }
        }

        public void rollback() {
            try {
                new RollbackTransactionRequest(this.transactionId).executeForResult(RemoteDomainControllerSlaveClient.this.getConnectionStrategy());
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "Failed rolling back management transaction %s on host %s", (Object)this.transactionId, (Object)RemoteDomainControllerSlaveClient.this.hostId);
            }
        }
    }

    private class RollbackTransactionRequest
    extends ModelControllerRequest<Boolean> {
        private final ModelNode transactionId;

        RollbackTransactionRequest(ModelNode transactionId) {
            this.transactionId = transactionId;
        }

        protected byte getRequestCode() {
            return 39;
        }

        protected byte getResponseCode() {
            return 40;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(48);
            this.transactionId.writeExternal(output);
        }
    }

    private class CommitTransactionRequest
    extends ModelControllerRequest<Boolean> {
        private final ModelNode transactionId;

        CommitTransactionRequest(ModelNode transactionId) {
            this.transactionId = transactionId;
        }

        protected byte getRequestCode() {
            return 37;
        }

        protected byte getResponseCode() {
            return 38;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(48);
            this.transactionId.writeExternal(output);
        }
    }

    private abstract class TransactionalRequest<T>
    extends ModelControllerRequest<T> {
        private final Operation operation;
        private final ModelNode transactionId;

        TransactionalRequest(Operation operation, ControllerTransactionContext transaction) {
            this.operation = operation;
            this.transactionId = transaction.getTransactionId();
            transaction.registerResource((ControllerResource)new ControllerResourceProxy(this.transactionId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(48);
            this.transactionId.writeExternal(output);
            output.write(96);
            this.operation.getOperation().writeExternal(output);
            List streams = this.operation.getInputStreams();
            for (InputStream in : streams) {
                output.write(104);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    int read;
                    byte[] buffer = new byte[8192];
                    while ((read = in.read(buffer)) != -1) {
                        bout.write(buffer, 0, read);
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                }
                byte[] bytes = bout.toByteArray();
                StreamUtils.writeInt((OutputStream)output, (int)bytes.length);
                try {
                    for (byte b : bytes) {
                        output.write(b);
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                }
            }
            output.write(105);
        }
    }

    private class ExecuteAsyncTransactionalRequest
    extends TransactionalRequest<ModelNode> {
        private final AsynchronousOperation result;
        private final ResultHandler handler;

        ExecuteAsyncTransactionalRequest(AsynchronousOperation result, Operation operation, ResultHandler handler, ControllerTransactionContext transaction) {
            super(operation, transaction);
            this.result = result;
            this.handler = handler;
        }

        protected byte getRequestCode() {
            return 33;
        }

        protected byte getResponseCode() {
            return 34;
        }

        protected ModelNode receiveResponse(InputStream input) throws IOException {
            block12: {
                try {
                    while (true) {
                        int command = input.read();
                        switch (command) {
                            case 96: {
                                this.result.setCompensatingOperation(RemoteDomainControllerSlaveClient.this.readNode(input));
                                break;
                            }
                            case 99: {
                                ProtocolUtils.expectHeader((InputStream)input, (int)98);
                                int length = StreamUtils.readInt((InputStream)input);
                                String[] location = new String[length];
                                for (int i = 0; i < length; ++i) {
                                    location[i] = StreamUtils.readUTFZBytes((InputStream)input);
                                }
                                ProtocolUtils.expectHeader((InputStream)input, (int)96);
                                ModelNode node = RemoteDomainControllerSlaveClient.this.readNode(input);
                                this.handler.handleResultFragment(location, node);
                                break;
                            }
                            case 101: {
                                this.handler.handleCancellation();
                                break block12;
                            }
                            case 103: {
                                ModelNode node = RemoteDomainControllerSlaveClient.this.readNode(input);
                                this.handler.handleFailed(node);
                                break block12;
                            }
                            case 100: {
                                this.handler.handleResultComplete();
                                break block12;
                            }
                            case 102: {
                                this.result.setAsynchronousId(StreamUtils.readInt((InputStream)input));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown response code " + command);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.handler.handleFailed(new ModelNode().set(e.toString()));
                }
            }
            return null;
        }
    }

    private class ExecuteSynchronousTransactionalRequest
    extends TransactionalRequest<ModelNode> {
        ExecuteSynchronousTransactionalRequest(Operation operation, ControllerTransactionContext transaction) {
            super(operation, transaction);
        }

        protected byte getRequestCode() {
            return 35;
        }

        protected byte getResponseCode() {
            return 36;
        }

        protected ModelNode receiveResponse(InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)96);
            return RemoteDomainControllerSlaveClient.this.readNode(input);
        }
    }

    private class AsynchronousOperation
    implements Cancellable {
        private SimpleFuture<ModelNode> compensatingOperation = new SimpleFuture();
        private boolean compensatingOpSet = false;
        private SimpleFuture<Integer> asynchronousId = new SimpleFuture();

        private AsynchronousOperation() {
        }

        public boolean cancel() {
            this.setCompensatingOperation(new ModelNode());
            try {
                int i = this.asynchronousId.get();
                if (i >= 0) {
                    return (Boolean)new CancelAsynchronousOperationRequest(i).executeForResult(RemoteDomainControllerSlaveClient.this.getConnectionStrategy());
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not cancel request ", e);
            }
        }

        void setAsynchronousId(int i) {
            this.asynchronousId.set(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCompensatingOperation(ModelNode compensatingOp) {
            SimpleFuture<ModelNode> simpleFuture = this.compensatingOperation;
            synchronized (simpleFuture) {
                if (!this.compensatingOpSet) {
                    this.compensatingOperation.set(compensatingOp);
                    this.compensatingOpSet = true;
                }
            }
        }

        ModelNode getCompensatingOperation() {
            try {
                return this.compensatingOperation.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Could not obtain compensating operation", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Could not obtain compensating operation", e);
            }
        }
    }

    private abstract class ModelControllerRequest<T>
    extends ManagementRequest<T> {
        private ModelControllerRequest() {
        }

        protected byte getHandlerId() {
            return 16;
        }
    }
}

