/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerImpl;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.ModelCombiner;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.protocol.Connection;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

class ServerInventory
implements ManagedServerLifecycleCallback {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private final Map<String, ManagedServer> servers = Collections.synchronizedMap(new HashMap());
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final InetSocketAddress managementAddress;
    private volatile HostControllerImpl hostController;
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;

    ServerInventory(HostControllerEnvironment environment, InetSocketAddress managementAddress, ProcessControllerClient processControllerClient) {
        this.environment = environment;
        this.managementAddress = managementAddress;
        this.processControllerClient = processControllerClient;
    }

    void setHostController(HostControllerImpl hostController) {
        this.hostController = hostController;
    }

    synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not get the server inventory in 30 seconds");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.processInfos;
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    ServerStatus determineServerStatus(String serverName) {
        ServerStatus status;
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer client = this.servers.get(processName);
        if (client == null) {
            status = ServerStatus.STOPPED;
        } else {
            switch (client.getState()) {
                case AVAILABLE: 
                case BOOTING: 
                case STARTING: {
                    status = ServerStatus.STARTING;
                    break;
                }
                case FAILED: 
                case MAX_FAILED: {
                    status = ServerStatus.FAILED;
                    break;
                }
                case STARTED: {
                    status = ServerStatus.STARTED;
                    break;
                }
                case STOPPING: {
                    status = ServerStatus.STOPPING;
                    break;
                }
                case STOPPED: {
                    status = ServerStatus.STOPPED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + client.getState());
                }
            }
        }
        return status;
    }

    ServerStatus startServer(String serverName, ModelNode hostModel, DomainController domainController) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            log.warnf("Existing server [%s] with state: %s", (Object)processName, (Object)existing.getState());
            return this.determineServerStatus(serverName);
        }
        log.infof("Starting server %s", (Object)serverName);
        ManagedServer server = this.createManagedServer(serverName, hostModel, domainController);
        this.servers.put(processName, server);
        try {
            server.createServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to create server process %s", (Object)serverName);
        }
        try {
            server.startServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to start server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    void reconnectServer(String serverName, ModelNode hostModel, DomainController domainController, boolean running) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            log.warnf("existing server [%s] with state: %s", (Object)processName, (Object)existing.getState());
        }
        log.info((Object)("Reconnecting server " + serverName));
        ManagedServer server = this.createManagedServer(serverName, hostModel, domainController);
        this.servers.put(processName, server);
        if (running) {
            try {
                server.reconnectServerProcess(this.environment.getHostControllerPort());
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Failed to send reconnect message to server %s", (Object)serverName);
            }
        }
    }

    ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode hostModel, DomainController domainController) {
        this.stopServer(serverName, gracefulTimeout);
        return this.startServer(serverName, hostModel, domainController);
    }

    ServerStatus stopServer(String serverName, int gracefulTimeout) {
        log.info((Object)("stopping server " + serverName));
        String processName = ManagedServer.getServerProcessName(serverName);
        try {
            ManagedServer server = this.servers.get(processName);
            if (server != null) {
                server.setState(ServerState.STOPPING);
                if (gracefulTimeout > -1) {
                    log.warnf("Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.", (Object)serverName);
                    server.stopServerProcess();
                    server.removeServerProcess();
                } else {
                    server.stopServerProcess();
                    server.removeServerProcess();
                }
            }
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to stop server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void serverRegistered(String serverName, Connection connection) {
        try {
            ManagedServer server = this.servers.get(serverName);
            if (server == null) {
                log.errorf("No server called %s available", (Object)serverName);
                return;
            }
            server.setServerManagementConnection(connection);
            if (!this.environment.isRestart()) {
                this.checkState(server, ServerState.STARTING);
            }
            server.setState(ServerState.STARTED);
            this.hostController.registerRunningServer(server.getServerName(), server.getServerConnection());
            server.resetRespawnCount();
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Could not start server %s", (Object)serverName);
        }
    }

    @Override
    public void serverStartFailed(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.FAILED);
    }

    @Override
    public void serverStopped(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists for stop", (Object)serverName);
            return;
        }
        this.hostController.unregisterRunningServer(server.getServerName());
        if (server.getState() != ServerState.STOPPING) {
            try {
                if (server.incrementAndGetRespawnCount() < 10) {
                    server.startServerProcess();
                    return;
                }
                server.setState(ServerState.MAX_FAILED);
            }
            catch (IOException e) {
                log.error((Object)("Failed to start server " + serverName), (Throwable)e);
            }
        }
        this.servers.remove(serverName);
    }

    private void checkState(ManagedServer server, ServerState expected) {
        ServerState state = server.getState();
        if (state != expected) {
            log.warnf("Server %s is not in the expected %s state: %s", (Object)server.getServerProcessName(), (Object)expected, (Object)state);
        }
    }

    private ManagedServer createManagedServer(String serverName, ModelNode hostModel, DomainController domainController) {
        ModelCombiner combiner = new ModelCombiner(serverName, hostModel, domainController, this.environment);
        return new ManagedServer(serverName, this.processControllerClient, this.managementAddress, combiner);
    }

    HostControllerEnvironment getEnvironment() {
        return this.environment;
    }
}

