/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class SpecifiedInterfaceAddHandler
extends InterfaceAddHandler {
    private static Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    public static SpecifiedInterfaceAddHandler INSTANCE = new SpecifiedInterfaceAddHandler();

    private SpecifiedInterfaceAddHandler() {
        super(true);
    }

    protected OperationResult installInterface(final String name, final ParsedInterfaceCriteria criteria, OperationContext context, final ResultHandler resultHandler, ModelNode compensatingOp) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ServiceBuilder builder = target.addService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{name}), SpecifiedInterfaceAddHandler.this.createInterfaceService(name, criteria));
                    builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOp);
    }

    Service<NetworkInterfaceBinding> createInterfaceService(String name, ParsedInterfaceCriteria criteria) {
        return new NetworkInterfaceService(name, criteria.isAnyLocalV4(), criteria.isAnyLocalV6(), criteria.isAnyLocal(), (InterfaceCriteria)new OverallInterfaceCriteria(criteria.getCriteria()));
    }

    static final class OverallInterfaceCriteria
    implements InterfaceCriteria {
        private static final long serialVersionUID = -5417786897309925997L;
        private final Set<InterfaceCriteria> interfaceCriteria;

        public OverallInterfaceCriteria(Set<InterfaceCriteria> criteria) {
            this.interfaceCriteria = criteria;
        }

        public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            for (InterfaceCriteria criteria : this.interfaceCriteria) {
                InetAddress bindAddress = criteria.isAcceptable(networkInterface, address);
                if (bindAddress == null) {
                    return null;
                }
                log.tracef("%s accepted, provided address: %s", (Object)criteria, (Object)bindAddress);
                addresses.add(bindAddress);
            }
            InetAddress bindAddress = null;
            if (addresses.size() > 0) {
                if (addresses.size() == 1) {
                    bindAddress = (InetAddress)addresses.iterator().next();
                } else if (addresses.size() > 2) {
                    log.warnf("More than two unique criteria addresses were seen: %s\n", (Object)addresses.toString());
                } else {
                    addresses.remove(address);
                    if (addresses.size() == 1) {
                        bindAddress = (InetAddress)addresses.iterator().next();
                    } else {
                        log.warnf("Two unique criteria addresses were seen: %s\n", (Object)addresses.toString());
                    }
                }
            }
            return bindAddress;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OverallInterfaceCriteria(");
            for (InterfaceCriteria criteria : this.interfaceCriteria) {
                sb.append(criteria.toString());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }
    }
}

