/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class RemoteDomainControllerAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    public static final RemoteDomainControllerAddHandler INSTANCE = new RemoteDomainControllerAddHandler();

    public static ModelNode getAddDomainControllerOperation(ModelNode address, String host, int port) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("host").set(host);
        op.get("port").set(port);
        return op;
    }

    RemoteDomainControllerAddHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        try {
            ModelNode model = context.getSubModel();
            model.get(new String[]{"domain-controller", "remote", "port"}).set(operation.require("port").asInt());
            model.get(new String[]{"domain-controller", "remote", "host"}).set(operation.require("host").asString());
            resultHandler.handleResultComplete();
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

