/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.descriptions.HostDescriptionProviders;
import org.jboss.as.host.controller.operations.LocalDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerAddHandler;
import org.jboss.as.host.controller.operations.ServerRemoveHandler;
import org.jboss.as.server.operations.ExtensionAddHandler;
import org.jboss.as.server.operations.ExtensionRemoveHandler;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.NativeManagementAddHandler;
import org.jboss.as.server.operations.SystemPropertyAddHandler;
import org.jboss.as.server.operations.SystemPropertyRemoveHandler;
import org.jboss.as.server.operations.sockets.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.operations.sockets.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostModelUtil {
    public static ModelNode createCoreModel() {
        ModelNode root = new ModelNode();
        root.get("name");
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("extension");
        root.get("path");
        root.get("system-property");
        root.get("management-interfaces");
        root.get("server-config");
        root.get("domain-controller");
        root.get("interface");
        root.get("jvm");
        root.get("server");
        return root;
    }

    public static ModelNodeRegistration createHostRegistry(ExtensibleConfigurationPersister configurationPersister) {
        ModelNodeRegistration root = ModelNodeRegistration.Factory.create((DescriptionProvider)HostDescriptionProviders.ROOT_PROVIDER);
        root.registerOperationHandler("resolve-address", (OperationHandler)GlobalOperationHandlers.RESOLVE, (DescriptionProvider)GlobalOperationHandlers.RESOLVE, false, OperationEntry.EntryType.PRIVATE);
        root.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("read-resource-description", (OperationHandler)GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-children-types", (OperationHandler)GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true);
        root.registerOperationHandler("read-operation-names", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-operation-description", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("add-namespace", (OperationHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-system-property", (OperationHandler)SystemPropertyAddHandler.INSTANCE, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-system-property", (OperationHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        root.registerReadWriteAttribute("name", null, (OperationHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration managementNative = root.registerSubModel(PathElement.pathElement((String)"management-interfaces", (String)"native-interface"), CommonProviders.MANAGEMENT_PROVIDER);
        managementNative.registerOperationHandler("add", (OperationHandler)NativeManagementAddHandler.INSTANCE, (DescriptionProvider)NativeManagementAddHandler.INSTANCE, false);
        ModelNodeRegistration managementHttp = root.registerSubModel(PathElement.pathElement((String)"management-interfaces", (String)"http-interface"), CommonProviders.MANAGEMENT_PROVIDER);
        managementHttp.registerOperationHandler("add", (OperationHandler)HttpManagementAddHandler.INSTANCE, (DescriptionProvider)HttpManagementAddHandler.INSTANCE, false);
        root.registerOperationHandler("write-local-domain-controller", (OperationHandler)LocalDomainControllerAddHandler.INSTANCE, (DescriptionProvider)LocalDomainControllerAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-local-domain-controller", (OperationHandler)LocalDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)LocalDomainControllerRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("write-remote-domain-controller", (OperationHandler)RemoteDomainControllerAddHandler.INSTANCE, (DescriptionProvider)RemoteDomainControllerAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-remote-domain-controller", (OperationHandler)RemoteDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)RemoteDomainControllerRemoveHandler.INSTANCE, false);
        ModelNodeRegistration extensions = root.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(root, null, (SubsystemXmlWriterRegistry)configurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
        ModelNodeRegistration jvms = root.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ModelNodeRegistration)jvms);
        ModelNodeRegistration paths = root.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ModelNodeRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        ModelNodeRegistration servers = root.registerSubModel(PathElement.pathElement((String)"server-config"), HostDescriptionProviders.SERVER_PROVIDER);
        servers.registerOperationHandler("add", (OperationHandler)ServerAddHandler.INSTANCE, (DescriptionProvider)ServerAddHandler.INSTANCE, false);
        servers.registerOperationHandler("remove", (OperationHandler)ServerRemoveHandler.INSTANCE, (DescriptionProvider)ServerRemoveHandler.INSTANCE, false);
        servers.registerOperationHandler("add-system-property", (OperationHandler)SystemPropertyAddHandler.INSTANCE, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE, false);
        servers.registerOperationHandler("remove-system-property", (OperationHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        servers.registerReadWriteAttribute("auto-start", null, (OperationHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-group", null, WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("priority", null, (OperationHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("cpu-affinity", null, (OperationHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration serverPaths = servers.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverPaths.registerOperationHandler("add", (OperationHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        serverPaths.registerOperationHandler("remove", (OperationHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ModelNodeRegistration serverInterfaces = servers.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverInterfaces.registerOperationHandler("add", (OperationHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        serverInterfaces.registerOperationHandler("remove", (OperationHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        ModelNodeRegistration serverVMs = servers.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ModelNodeRegistration)serverVMs);
        return root;
    }
}

