/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.as.embedded.EmbeddedMessages;
import org.jboss.as.embedded.EmbeddedStandAloneServerFactory;
import org.jboss.as.embedded.SecurityActions;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.embedded.StandaloneServerIndirection;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;

public class EmbeddedServerFactory {
    private static final String MODULE_ID_EMBEDDED = "org.jboss.as.embedded";
    private static final String MODULE_ID_LOGMANAGER = "org.jboss.logmanager";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_LOGMANAGER = "java.util.logging.manager";
    private static final String SYSPROP_KEY_JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
    private static final String SYSPROP_KEY_JBOSS_BUNDLES_DIR = "jboss.bundles.dir";
    private static final String SYSPROP_VALUE_JBOSS_LOGMANAGER = "org.jboss.logmanager.LogManager";

    private EmbeddedServerFactory() {
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String bundlePath, String ... systemPackages) {
        return EmbeddedServerFactory.create(jbossHomePath, modulePath, bundlePath, systemPackages, null);
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String bundlePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedMessages.MESSAGES.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedMessages.MESSAGES.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + "modules";
        }
        if (bundlePath == null) {
            bundlePath = jbossHomeDir.getAbsolutePath() + File.separator + "bundles";
        }
        return EmbeddedServerFactory.create(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, bundlePath, cmdargs);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir) {
        String bundlePath = jbossHomeDir.getAbsolutePath() + File.separator + "bundles";
        return EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, bundlePath, new String[0]);
    }

    private static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir, String bundlePath, String[] cmdargs) {
        Object standaloneServerImpl;
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.setupBundlePath(bundlePath);
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        SecurityActions.setSystemProperty(SYSPROP_KEY_JBOSS_HOME_DIR, jbossHomeDir.getAbsolutePath());
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedMessages.MESSAGES.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(EmbeddedStandAloneServerFactory.class.getName());
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedMessages.MESSAGES.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedStandAloneServerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedMessages.MESSAGES.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        try {
            Properties sysprops = SecurityActions.getSystemProperties();
            Map<String, String> sysenv = SecurityActions.getSystemEnvironment();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            standaloneServerImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            throw EmbeddedMessages.MESSAGES.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            throw EmbeddedMessages.MESSAGES.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return new StandaloneServerIndirection(standaloneServerClass, standaloneServerImpl);
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
        assert (modulePath != null) : "modulePath not null";
        SecurityActions.setSystemProperty(SYSPROP_KEY_JBOSS_MODULES_DIR, EmbeddedServerFactory.trimPathToModulesDir(modulePath));
        String classPath = SecurityActions.getSystemProperty(SYSPROP_KEY_CLASS_PATH);
        try {
            ModuleLoader moduleLoader;
            SecurityActions.clearSystemProperty(SYSPROP_KEY_CLASS_PATH);
            SecurityActions.setSystemProperty(SYSPROP_KEY_MODULE_PATH, modulePath);
            StringBuffer packages = new StringBuffer("org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
            if (systemPackages != null) {
                for (String packageName : systemPackages) {
                    packages.append("," + packageName);
                }
            }
            SecurityActions.setSystemProperty("jboss.modules.system.pkgs", packages.toString());
            ModuleLoader moduleLoader2 = moduleLoader = Module.getBootModuleLoader();
            return moduleLoader2;
        }
        finally {
            SecurityActions.setSystemProperty(SYSPROP_KEY_CLASS_PATH, classPath);
        }
    }

    private static void setupBundlePath(String bundlePath) {
        assert (bundlePath != null) : "bundlePath not null";
        File bundlesDir = new File(bundlePath);
        assert (bundlesDir.isDirectory()) : "bundlesDir not a directory";
        SecurityActions.setSystemProperty(SYSPROP_KEY_JBOSS_BUNDLES_DIR, bundlesDir.getAbsolutePath());
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedMessages.MESSAGES.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingSystem(ModuleLoader moduleLoader) {
        Module logModule;
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)MODULE_ID_LOGMANAGER);
        try {
            logModule = moduleLoader.loadModule(logModuleId);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedMessages.MESSAGES.moduleLoaderError(mle, MODULE_ID_LOGMANAGER, moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)logModuleClassLoader);
            SecurityActions.setSystemProperty(SYSPROP_KEY_LOGMANAGER, SYSPROP_VALUE_JBOSS_LOGMANAGER);
            Class<?> actualLogManagerClass = LogManager.getLogManager().getClass();
            if (actualLogManagerClass == LogManager.class) {
                System.err.println("Cannot not load JBoss LogManager. The LogManager has likely been accessed prior to this initialization.");
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }
}

