/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;

final class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static void remotingContextSetConnection(Connection connection) {
        SecurityActions.remotingContextAccociationActions().setConnection(connection);
    }

    static void remotingContextClear() {
        SecurityActions.remotingContextAccociationActions().clear();
    }

    private static RemotingContextAssociationActions remotingContextAccociationActions() {
        return System.getSecurityManager() == null ? RemotingContextAssociationActions.NON_PRIVILEGED : RemotingContextAssociationActions.PRIVILEGED;
    }

    private static interface RemotingContextAssociationActions {
        public static final RemotingContextAssociationActions NON_PRIVILEGED = new RemotingContextAssociationActions(){

            @Override
            public void setConnection(Connection connection) {
                RemotingContext.setConnection((Connection)connection);
            }

            @Override
            public void clear() {
                RemotingContext.clear();
            }
        };
        public static final RemotingContextAssociationActions PRIVILEGED = new RemotingContextAssociationActions(){
            private PrivilegedAction<Void> CLEAR_ACTION = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    NON_PRIVILEGED.clear();
                    return null;
                }
            };

            @Override
            public void setConnection(final Connection connection) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.setConnection(connection);
                        return null;
                    }
                });
            }

            @Override
            public void clear() {
                AccessController.doPrivileged(this.CLEAR_ACTION);
            }
        };

        public void setConnection(Connection var1);

        public void clear();
    }
}

