/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.invocationmetrics;

import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.invocationmetrics.WaitTimeInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class ExecutionTimeInterceptor
extends AbstractEJBInterceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new ExecutionTimeInterceptor());

    private ExecutionTimeInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        EJBComponent component = ExecutionTimeInterceptor.getComponent(context, EJBComponent.class);
        if (!component.isStatisticsEnabled()) {
            return context.proceed();
        }
        Long startWaitTime = (Long)context.getPrivateData(WaitTimeInterceptor.START_WAIT_TIME);
        long waitTime = startWaitTime != null && startWaitTime != 0L ? System.currentTimeMillis() - startWaitTime : 0L;
        component.getInvocationMetrics().startInvocation();
        long start = System.currentTimeMillis();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            long executionTime = System.currentTimeMillis() - start;
            component.getInvocationMetrics().finishInvocation(waitTime, executionTime);
        }
    }
}

