/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class EjbExceptionTransformingInterceptorFactories {
    private static final ThreadLocal<CreateException> CREATE_EXCEPTION = new ThreadLocal();
    public static final InterceptorFactory REMOTE_INSTANCE = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            try {
                return context.proceed();
            }
            catch (EJBTransactionRequiredException e) {
                throw new TransactionRequiredException(e.getMessage());
            }
            catch (EJBTransactionRolledbackException e) {
                throw new TransactionRolledbackException(e.getMessage());
            }
            catch (NoSuchEJBException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            catch (EJBException e) {
                CreateException createException = EjbExceptionTransformingInterceptorFactories.popCreateException();
                if (createException != null) {
                    throw createException;
                }
                throw new RemoteException("Invocation failed", e);
            }
        }
    });
    public static final InterceptorFactory LOCAL_INSTANCE = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            try {
                return context.proceed();
            }
            catch (EJBTransactionRequiredException e) {
                throw new TransactionRequiredLocalException(e.getMessage());
            }
            catch (EJBTransactionRolledbackException e) {
                throw new TransactionRolledbackLocalException(e.getMessage(), e.getCausedByException());
            }
            catch (NoSuchEJBException e) {
                throw new NoSuchObjectLocalException(e.getMessage(), e.getCausedByException());
            }
            catch (NoSuchEntityException e) {
                throw new NoSuchObjectLocalException(e.getMessage(), e.getCausedByException());
            }
            catch (EJBException e) {
                CreateException createException = EjbExceptionTransformingInterceptorFactories.popCreateException();
                if (createException != null) {
                    throw createException;
                }
                throw e;
            }
        }
    });

    public static void setCreateException(CreateException exception) {
        CREATE_EXCEPTION.set(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateException popCreateException() {
        try {
            CreateException createException = CREATE_EXCEPTION.get();
            return createException;
        }
        finally {
            CREATE_EXCEPTION.remove();
        }
    }
}

