/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.io.Serializable;
import org.jboss.as.ejb3.EjbMessages;

public final class DeploymentModuleIdentifier
implements Serializable {
    private final String applicationName;
    private final String moduleName;
    private final String distinctName;

    public DeploymentModuleIdentifier(String applicationName, String moduleName, String distinctName) {
        if (applicationName == null) {
            throw EjbMessages.MESSAGES.paramCannotBeNull("Application name");
        }
        if (moduleName == null) {
            throw EjbMessages.MESSAGES.paramCannotBeNull("Module name");
        }
        if (distinctName == null) {
            throw EjbMessages.MESSAGES.paramCannotBeNull("Distinct name");
        }
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentModuleIdentifier that = (DeploymentModuleIdentifier)o;
        if (!this.applicationName.equals(that.applicationName)) {
            return false;
        }
        if (this.distinctName != null ? !this.distinctName.equals(that.distinctName) : that.distinctName != null) {
            return false;
        }
        return this.moduleName.equals(that.moduleName);
    }

    public int hashCode() {
        int result = this.applicationName.hashCode();
        result = 31 * result + this.moduleName.hashCode();
        result = 31 * result + (this.distinctName != null ? this.distinctName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DeploymentModuleIdentifier{applicationName='" + this.applicationName + '\'' + ", moduleName='" + this.moduleName + '\'' + ", distinctName='" + this.distinctName + '\'' + '}';
    }
}

