/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.invocation.InterceptorContext;

public abstract class SessionBeanComponent
extends EJBComponent {
    protected final Map<String, AccessTimeoutDetails> beanLevelAccessTimeout;
    private final ExecutorService asyncExecutor;

    protected SessionBeanComponent(SessionBeanComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.beanLevelAccessTimeout = ejbComponentCreateService.getBeanAccessTimeout();
        this.asyncExecutor = (ExecutorService)ejbComponentCreateService.getAsyncExecutorService().getOptionalValue();
    }

    public <T> T getBusinessObject(Class<T> businessInterface, InterceptorContext context) throws IllegalStateException {
        if (businessInterface == null) {
            throw EjbMessages.MESSAGES.businessInterfaceIsNull();
        }
        return this.createViewInstanceProxy(businessInterface, Collections.<Object, Object>emptyMap());
    }

    public EJBLocalObject getEJBLocalObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbLocalObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBLocalObject");
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.<Object, Object>emptyMap(), this.getEjbLocalObjectViewServiceName());
    }

    public EJBObject getEJBObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        return this.createViewInstanceProxy(EJBObject.class, Collections.<Object, Object>emptyMap(), this.getEjbObjectViewServiceName());
    }

    public ExecutorService getAsynchronousExecutor() {
        return this.asyncExecutor;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw EjbMessages.MESSAGES.getRollBackOnlyIsNotAllowWithSupportsAttribute();
        }
        return super.getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw EjbLogger.EJB3_LOGGER.setRollbackOnlyNotAllowedForSupportsTxAttr();
        }
        super.setRollbackOnly();
    }
}

