/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.factory;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.impl.GroupAwareCache;
import org.jboss.as.ejb3.cache.impl.backing.GroupAwareBackingCacheImpl;
import org.jboss.as.ejb3.cache.impl.backing.PassivatingBackingCacheImpl;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupContainer;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupMemberContainer;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.spi.BackingCacheLifecycleListener;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;

public class GroupAwareCacheFactory<K extends Serializable, V extends Cacheable<K>>
implements CacheFactory<K, V>,
BackingCacheLifecycleListener,
IdentifierFactory<UUID> {
    private final AtomicReference<SerializationGroupContainer<K, V>> groupContainerRef = new AtomicReference();
    private final AtomicInteger memberCounter = new AtomicInteger();
    private final BackingCacheEntryStoreSource<K, V, UUID> storeSource;

    public GroupAwareCacheFactory(BackingCacheEntryStoreSource<K, V, UUID> storeSource) {
        this.storeSource = storeSource;
    }

    @Override
    public Cache<K, V> createCache(String beanName, IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, PassivationManager<K, V> passivationManager, StatefulTimeoutInfo timeout) {
        SerializationGroupContainer<K, V> groupContainer = this.groupContainerRef.get();
        if (groupContainer == null && !this.groupContainerRef.compareAndSet(null, groupContainer = this.createGroupContainer(passivationManager, timeout))) {
            groupContainer = this.groupContainerRef.get();
        }
        groupContainer.addMemberPassivationManager(passivationManager);
        PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache = groupContainer.getGroupCache();
        SerializationGroupMemberContainer<K, V, UUID> container = new SerializationGroupMemberContainer<K, V, UUID>(passivationManager, groupCache, this.storeSource);
        BackingCacheEntryStore store = this.storeSource.createIntegratedObjectStore(beanName, identifierFactory, container, timeout);
        container.setBackingCacheEntryStore(store);
        GroupAwareBackingCacheImpl<K, V, UUID> backingCache = new GroupAwareBackingCacheImpl<K, V, UUID>(factory, container, groupCache, Executors.defaultThreadFactory());
        backingCache.addLifecycleListener(this);
        return new GroupAwareCache(backingCache, true);
    }

    private SerializationGroupContainer<K, V> createGroupContainer(PassivationManager<K, V> passivationManager, StatefulTimeoutInfo timeout) {
        SerializationGroupContainer container = new SerializationGroupContainer(passivationManager);
        BackingCacheEntryStore<UUID, Cacheable<UUID>, V> store = this.storeSource.createGroupIntegratedObjectStore(this, container, timeout);
        PassivatingBackingCacheImpl groupCache = new PassivatingBackingCacheImpl(container, container, container, store);
        container.setGroupCache(groupCache);
        return container;
    }

    @Override
    public UUID createIdentifier() {
        return UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleChange(BackingCacheLifecycleListener.LifecycleState newState) {
        switch (newState) {
            case STARTING: {
                PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<UUID, Cacheable<UUID>, UUID>> groupCache;
                if (this.memberCounter.incrementAndGet() != 1) break;
                PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<UUID, Cacheable<UUID>, UUID>> passivatingBackingCache = groupCache = this.groupContainerRef.get().getGroupCache();
                synchronized (passivatingBackingCache) {
                    groupCache.start();
                    break;
                }
            }
            case STOPPED: {
                PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<UUID, Cacheable<UUID>, UUID>> groupCache;
                if (this.memberCounter.decrementAndGet() != 0) break;
                PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<UUID, Cacheable<UUID>, UUID>> passivatingBackingCache = groupCache = this.groupContainerRef.get().getGroupCache();
                synchronized (passivatingBackingCache) {
                    groupCache.stop();
                    break;
                }
            }
        }
    }
}

