/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleValue;

public class RangeValue
implements ScheduleValue {
    public static final String RANGE_SEPARATOR = "-";
    private static final Pattern RANGE_PATTERN;
    private String rangeStart;
    private String rangeEnd;

    public RangeValue(String range) {
        String[] values = this.getRangeValues(range);
        if (values == null || values.length != 2) {
            throw new IllegalArgumentException("Invalid range value: " + range);
        }
        this.rangeStart = values[0].trim();
        this.rangeEnd = values[1].trim();
    }

    public String getStart() {
        return this.rangeStart;
    }

    public String getEnd() {
        return this.rangeEnd;
    }

    public static boolean accepts(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = RANGE_PATTERN.matcher(value);
        return matcher.matches();
    }

    private String[] getRangeValues(String val) {
        if (val == null) {
            return null;
        }
        Matcher matcher = RANGE_PATTERN.matcher(val);
        if (!matcher.matches()) {
            return null;
        }
        String[] rangeVals = new String[]{matcher.group(1), matcher.group(3)};
        return rangeVals;
    }

    public String asString() {
        return this.rangeStart + RANGE_SEPARATOR + this.rangeStart;
    }

    static {
        String POSITIVE_OR_NEGATIVE_INTEGER = "\\s*-?\\s*\\d+\\s*";
        String WORD = "\\s*([1-5][a-zA-Z]{2})?\\s*[a-zA-Z]+\\s*[a-zA-Z]*\\s*";
        String OR = "|";
        String OPEN_GROUP = "(";
        String CLOSE_GROUP = ")";
        String rangeRegex = "(\\s*-?\\s*\\d+\\s*|\\s*([1-5][a-zA-Z]{2})?\\s*[a-zA-Z]+\\s*[a-zA-Z]*\\s*)-(\\s*-?\\s*\\d+\\s*|\\s*([1-5][a-zA-Z]{2})?\\s*[a-zA-Z]+\\s*[a-zA-Z]*\\s*)";
        RANGE_PATTERN = Pattern.compile(rangeRegex);
    }
}

