/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.Calendar;
import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;

public class Second
extends IntegerBasedExpression {
    public static final Integer MAX_SECOND = 59;
    public static final Integer MIN_SECOND = 0;

    public Second(String value) {
        super(value);
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(13);
        }
        if (this.absoluteValues.isEmpty()) {
            return null;
        }
        int currentSecond = currentCal.get(13);
        for (Integer second : this.absoluteValues) {
            if (currentSecond == second) {
                return currentSecond;
            }
            if (second <= currentSecond) continue;
            return second;
        }
        return (Integer)this.absoluteValues.first();
    }

    public int getFirst() {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return 0;
        }
        if (this.absoluteValues.isEmpty()) {
            throw new IllegalStateException("There are no valid seconds for expression: " + this.origValue);
        }
        return (Integer)this.absoluteValues.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_SECOND;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_SECOND;
    }

    @Override
    public boolean isRelativeValue(String value) {
        return false;
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: 
            case INCREMENT: {
                return true;
            }
        }
        return false;
    }
}

