/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.mk2.persistence.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.mk2.persistence.TimerPersistence;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;

public class FileTimerPersistence
implements TimerPersistence {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final File baseDir;
    private final boolean createIfNotExists;
    private static final Logger logger = Logger.getLogger(FileTimerPersistence.class);
    private final MarshallerFactory factory;
    private final MarshallingConfiguration configuration;
    private final ConcurrentMap<String, Map<String, TimerEntity>> timers = new ConcurrentHashMap<String, Map<String, TimerEntity>>();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final ConcurrentMap<String, String> directories = new ConcurrentHashMap<String, String>();
    private volatile boolean started = false;

    public FileTimerPersistence(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, File baseDir, boolean createIfNotExists, ModuleLoader moduleLoader) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.baseDir = baseDir;
        this.createIfNotExists = createIfNotExists;
        RiverMarshallerFactory factory = new RiverMarshallerFactory();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
        this.configuration = configuration;
        this.factory = factory;
    }

    @Override
    public synchronized void start() {
        this.started = true;
        if (!this.baseDir.exists()) {
            if (this.createIfNotExists) {
                if (!this.baseDir.mkdirs()) {
                    throw new RuntimeException("Could not create timer file store directory " + this.baseDir);
                }
            } else {
                throw new RuntimeException("Timer file store directory " + this.baseDir + " does not exist");
            }
        }
        if (!this.baseDir.isDirectory()) {
            throw new RuntimeException("Timer file store directory " + this.baseDir + " is not a directory");
        }
    }

    @Override
    public synchronized void stop() {
        this.timers.clear();
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistTimer(TimerEntity timerEntity) {
        block6: {
            Lock lock = this.getLock(timerEntity.getTimedObjectId());
            try {
                int status = this.transactionManager.getStatus();
                if (status == 6 || status == 5) {
                    try {
                        lock.lock();
                        Map<String, TimerEntity> map = this.getTimers(timerEntity.getTimedObjectId());
                        map.put(timerEntity.getId(), timerEntity);
                        this.writeFile(timerEntity);
                        break block6;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new PersistTransactionSynchronization(timerEntity, lock));
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerEntity loadTimer(String id, String timedObjectId) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            Map<String, TimerEntity> timers = this.getTimers(timedObjectId);
            TimerEntity timerEntity = timers.get(id);
            return timerEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimer(TimerEntity timerEntity) {
        Lock lock = this.getLock(timerEntity.getTimedObjectId());
        try {
            lock.lock();
            Map<String, TimerEntity> timers = this.getTimers(timerEntity.getTimedObjectId());
            timers.remove(timerEntity.getId());
            File file = this.fileName(timerEntity.getTimedObjectId(), timerEntity.getId());
            if (file.exists() && !file.delete()) {
                logger.error((Object)("Could not remove persistent timer " + file));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimerEntity> loadActiveTimers(String timedObjectId) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            Map<String, TimerEntity> timers = this.getTimers(timedObjectId);
            ArrayList<TimerEntity> arrayList = new ArrayList<TimerEntity>(timers.values());
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(String timedObjectId) {
        ReentrantLock addedLock;
        Lock lock = (Lock)this.locks.get(timedObjectId);
        if (lock == null && (lock = this.locks.putIfAbsent(timedObjectId, addedLock = new ReentrantLock())) == null) {
            lock = addedLock;
        }
        return lock;
    }

    private Map<String, TimerEntity> getTimers(String timedObjectId) {
        Map<String, TimerEntity> map = (Map<String, TimerEntity>)this.timers.get(timedObjectId);
        if (map == null) {
            map = this.loadTimersFromFile(timedObjectId);
            this.timers.put(timedObjectId, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TimerEntity> loadTimersFromFile(String timedObjectId) {
        HashMap<String, TimerEntity> timers = new HashMap<String, TimerEntity>();
        try {
            File file = new File(this.getDirectory(timedObjectId));
            if (!file.exists()) {
                return timers;
            }
            if (!file.isDirectory()) {
                logger.error((Object)(file + " is not a directory, could not restore timers"));
                return timers;
            }
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
            for (File timerFile : file.listFiles()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(timerFile);
                    unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
                    TimerEntity entity = (TimerEntity)unmarshaller.readObject(TimerEntity.class);
                    timers.put(entity.getId(), entity);
                    unmarshaller.finish();
                }
                catch (Exception e) {
                    logger.error((Object)("Could not restore timer from " + timerFile), (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)"error closing file ", (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not restore timers for " + timedObjectId), (Throwable)e);
        }
        return timers;
    }

    private File fileName(String timedObjectId, String timerId) {
        return new File(this.getDirectory(timedObjectId) + File.separator + timerId.replace(File.separator, "-"));
    }

    private String getDirectory(String timedObjectId) {
        String dirName = (String)this.directories.get(timedObjectId);
        if (dirName == null) {
            dirName = this.baseDir.getAbsolutePath() + File.separator + timedObjectId.replace(File.separator, "-");
            File file = new File(dirName);
            if (!file.exists() && !file.mkdirs()) {
                logger.error((Object)("Could not create directory " + file + " to persist EJB timers."));
            }
            this.directories.put(timedObjectId, dirName);
        }
        return dirName;
    }

    private void writeFile(TimerEntity entity) {
        File file = this.fileName(entity.getTimedObjectId(), entity.getId());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, false);
            Marshaller marshaller = this.factory.createMarshaller(this.configuration);
            marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)fileOutputStream));
            marshaller.writeObject((Object)entity);
            marshaller.finish();
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"IOException closing file ", (Throwable)e);
                }
            }
        }
    }

    private final class PersistTransactionSynchronization
    implements Synchronization {
        private final TimerEntity timer;
        private final Lock lock;

        public PersistTransactionSynchronization(TimerEntity timer, Lock lock) {
            this.timer = timer;
            this.lock = lock;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                this.lock.lock();
                if (status == 3) {
                    Map map = FileTimerPersistence.this.getTimers(this.timer.getTimedObjectId());
                    map.put(this.timer.getId(), this.timer);
                    FileTimerPersistence.this.writeFile(this.timer);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

