/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.ForwardingTimerService;
import org.jboss.as.ejb3.timerservice.api.TimerService;
import org.jboss.as.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TimerServiceService
extends ForwardingTimerService
implements Service<javax.ejb.TimerService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb", "timerService"});
    private volatile TimerService timerService;
    private final InjectedValue<TimerServiceFactory> timerServiceFactoryInjectedValue = new InjectedValue();
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final Map<Method, List<AutoTimer>> autoTimers;
    private final ClassLoader classLoader;

    public TimerServiceService(Map<Method, List<AutoTimer>> autoTimers, ClassLoader classLoader) {
        this.autoTimers = autoTimers;
        this.classLoader = classLoader;
    }

    public synchronized void start(StartContext context) throws StartException {
        TimerServiceFactory timerServiceFactory = (TimerServiceFactory)this.timerServiceFactoryInjectedValue.getValue();
        EJBComponent component = (EJBComponent)this.ejbComponentInjectedValue.getValue();
        TimedObjectInvoker invoker = component.getTimedObjectInvoker();
        if (invoker == null) {
            throw new StartException("No timed object invoke for " + component);
        }
        TimerService timerService = (TimerService)timerServiceFactory.createTimerService(invoker);
        ArrayList<ScheduleTimer> timers = new ArrayList<ScheduleTimer>();
        for (Map.Entry<Method, List<AutoTimer>> entry : this.autoTimers.entrySet()) {
            for (AutoTimer timer : entry.getValue()) {
                timers.add(new ScheduleTimer(entry.getKey(), timer.getScheduleExpression(), timer.getTimerConfig()));
            }
        }
        timerServiceFactory.restoreTimerService(timerService, timers);
        this.timerService = timerService;
    }

    public synchronized void stop(StopContext context) {
        ((TimerServiceFactory)this.timerServiceFactoryInjectedValue.getValue()).suspendTimerService(this.timerService);
        this.timerService = null;
    }

    @Override
    protected javax.ejb.TimerService delegate() {
        TimerService timerService = this.timerService;
        if (timerService == null) {
            throw new IllegalStateException("TimerService is not started");
        }
        return timerService;
    }

    public javax.ejb.TimerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<TimerServiceFactory> getTimerServiceFactoryInjectedValue() {
        return this.timerServiceFactoryInjectedValue;
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }
}

