/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem10Parser;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem11Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemAdd;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemProviders;
import org.jboss.as.ejb3.subsystem.SetDefaultMDBPool;
import org.jboss.as.ejb3.subsystem.SetDefaultResourceAdapterName;
import org.jboss.as.ejb3.subsystem.SetDefaultSLSBPool;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolAdd;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolRemove;
import org.jboss.as.ejb3.subsystem.TimerServiceAdd;
import org.jboss.as.ejb3.subsystem.TimerServiceRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class EJB3Extension
implements Extension {
    public static final String SUBSYSTEM_NAME = "ejb3";
    public static final String NAMESPACE_1_0 = "urn:jboss:domain:ejb3:1.0";
    public static final String NAMESPACE_1_1 = "urn:jboss:domain:ejb3:1.1";
    private static final EJB3Subsystem10Parser ejb3Subsystem10Parser = new EJB3Subsystem10Parser();
    private static final EJB3Subsystem11Parser ejb3Subsystem11Parser = new EJB3Subsystem11Parser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel(EJB3SubsystemProviders.SUBSYSTEM);
        subsystem.registerXMLElementWriter((XMLElementWriter)ejb3Subsystem11Parser);
        subsystemRegistration.registerOperationHandler("add", (OperationStepHandler)EJB3SubsystemAdd.INSTANCE, (DescriptionProvider)EJB3SubsystemAdd.INSTANCE, false);
        subsystemRegistration.registerOperationHandler("describe", (OperationStepHandler)SubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystemRegistration.registerReadWriteAttribute("default-slsb-instance-pool", null, (OperationStepHandler)SetDefaultSLSBPool.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        subsystemRegistration.registerReadWriteAttribute("default-mdb-instance-pool", null, (OperationStepHandler)SetDefaultMDBPool.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        subsystemRegistration.registerReadWriteAttribute("default-resource-adapter-name", null, (OperationStepHandler)SetDefaultResourceAdapterName.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration strictMaxPoolRegistration = subsystemRegistration.registerSubModel(PathElement.pathElement((String)"strict-max-bean-instance-pool"), EJB3SubsystemProviders.STRICT_MAX_BEAN_INSTANCE_POOL);
        strictMaxPoolRegistration.registerOperationHandler("add", (OperationStepHandler)StrictMaxPoolAdd.INSTANCE, (DescriptionProvider)StrictMaxPoolAdd.INSTANCE, false);
        strictMaxPoolRegistration.registerOperationHandler("remove", (OperationStepHandler)StrictMaxPoolRemove.INSTANCE, (DescriptionProvider)StrictMaxPoolRemove.INSTANCE, false);
        ManagementResourceRegistration timerService = subsystemRegistration.registerSubModel(EJB3SubsystemModel.TIMER_SERVICE_PATH, EJB3SubsystemProviders.TIMER_SERVICE);
        timerService.registerOperationHandler("add", (OperationStepHandler)TimerServiceAdd.INSTANCE, (DescriptionProvider)TimerServiceAdd.INSTANCE, false);
        timerService.registerOperationHandler("remove", (OperationStepHandler)TimerServiceRemove.INSTANCE, (DescriptionProvider)TimerServiceRemove.INSTANCE, false);
        timerService.registerReadWriteAttribute("path", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        timerService.registerReadWriteAttribute("relative-to", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        timerService.registerReadWriteAttribute("core-threads", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        timerService.registerReadWriteAttribute("max-threads", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE_1_0, (XMLElementReader)ejb3Subsystem10Parser);
        context.setSubsystemXmlMapping(NAMESPACE_1_1, (XMLElementReader)ejb3Subsystem11Parser);
    }

    private static ModelNode createAddSubSystemOperation(ModelNode model) {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        return Util.getOperation((String)"add", (ModelNode)address, (ModelNode)model);
    }

    private static ModelNode createAddStrictMaxPoolOperation(String name, ModelNode model) {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.add("strict-max-bean-instance-pool", name);
        return Util.getOperation((String)"add", (ModelNode)address, (ModelNode)model);
    }

    private static ModelNode createTimerServiceOperation(ModelNode model) {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.add("service", "timer-service");
        return Util.getOperation((String)"add", (ModelNode)address, (ModelNode)model);
    }

    private static class SubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final SubsystemDescribeHandler INSTANCE = new SubsystemDescribeHandler();

        private SubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
            result.add(EJB3Extension.createAddSubSystemOperation(root.getModel()));
            for (Resource.ResourceEntry pool : root.getChildren("strict-max-bean-instance-pool")) {
                result.add(EJB3Extension.createAddStrictMaxPoolOperation(pool.getName(), pool.getModel()));
            }
            Resource timerService = root.getChild(EJB3SubsystemModel.TIMER_SERVICE_PATH);
            if (timerService != null) {
                result.add(EJB3Extension.createTimerServiceOperation(timerService.getModel()));
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    }
}

