/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.component.EJBComponentDescription;

public class EJBSecurityMetaData {
    private final String ejbName;
    private final String ejbClassName;
    private final String securityDomain;
    private final String runAsRole;
    private final Set<String> declaredRoles;

    public EJBSecurityMetaData(ComponentConfiguration componentConfiguration) {
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw new IllegalArgumentException(componentConfiguration.getComponentName() + " is not an EJB component");
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.ejbClassName = ejbComponentDescription.getEJBClassName();
        this.ejbName = ejbComponentDescription.getEJBName();
        this.runAsRole = ejbComponentDescription.getRunAs();
        this.securityDomain = ejbComponentDescription.getSecurityDomain();
        Set<String> roles = ejbComponentDescription.getDeclaredRoles();
        this.declaredRoles = roles == null ? Collections.emptySet() : Collections.unmodifiableSet(roles);
    }

    public Set<String> getDeclaredRoles() {
        return this.declaredRoles;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }
}

