/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import javax.annotation.security.RunAs;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;

public class RunAsMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public RunAsMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation runAs = clazz.getAnnotationInformation(RunAs.class);
        if (runAs == null) {
            return;
        }
        if (!runAs.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setRunAs((String)runAs.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String role;
        RunAsMetaData runAs;
        if (componentConfiguration.getDescriptorData() == null) {
            return;
        }
        SecurityIdentityMetaData identity = componentConfiguration.getDescriptorData().getSecurityIdentity();
        if (identity != null && (runAs = identity.getRunAs()) != null && (role = runAs.getRoleName()) != null && !role.trim().isEmpty()) {
            componentConfiguration.setRunAs(role.trim());
        }
    }
}

