/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.session.SessionInvocationContextInterceptor;
import org.jboss.as.ejb3.timerservice.TimerServiceFactoryService;
import org.jboss.as.ejb3.timerservice.TimerServiceService;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.TransactionSynchronizationRegistryService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class TimerServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(TimerServiceDeploymentProcessor.class);
    private final int coreThreads;
    private final int maxThreads;
    private final boolean enabled;

    public TimerServiceDeploymentProcessor(int coreThreads, int maxThreads, boolean enabled) {
        this.coreThreads = coreThreads;
        this.maxThreads = maxThreads;
        this.enabled = enabled;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (!this.enabled) {
            return;
        }
        final DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        boolean timerServiceRequired = false;
        for (final ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!component.isTimerServiceApplicable()) continue;
            timerServiceRequired = true;
            logger.debug((Object)("Installing timer service for component " + component.getComponentName()));
            component.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    configuration.addTimeoutInterceptor(SessionInvocationContextInterceptor.FACTORY, 784);
                    TimerServiceService service = new TimerServiceService(ejbComponentDescription.getScheduleMethods(), (ClassLoader)module.getClassLoader());
                    final ServiceName serviceName = component.getServiceName().append(TimerServiceService.SERVICE_NAME);
                    ServiceBuilder createBuilder = context.getServiceTarget().addService(serviceName, (Service)service);
                    createBuilder.addDependency(deploymentUnit.getServiceName().append(TimerServiceFactoryService.SERVICE_NAME), TimerServiceFactory.class, service.getTimerServiceFactoryInjectedValue());
                    createBuilder.addDependency(component.getCreateServiceName(), EJBComponent.class, service.getEjbComponentInjectedValue());
                    createBuilder.install();
                    ejbComponentDescription.setTimerService(service);
                    configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(serviceName);
                        }
                    });
                }
            });
        }
        if (timerServiceRequired) {
            this.addTimerService(phaseContext.getServiceTarget(), deploymentUnit, module);
        }
    }

    private void addTimerService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Module module) {
        String name = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "--" + deploymentUnit.getName();
        TimerServiceFactoryService factoryService = new TimerServiceFactoryService(this.coreThreads, this.maxThreads, name, module);
        ServiceBuilder factoryBuilder = serviceTarget.addService(deploymentUnit.getServiceName().append(TimerServiceFactoryService.SERVICE_NAME), (Service)factoryService);
        factoryBuilder.addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, factoryService.getTransactionManagerInjectedValue());
        factoryBuilder.addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, factoryService.getTransactionSynchronizationRegistryInjectedValue());
        factoryBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, TimerServiceFactoryService.PATH_SERVICE_NAME, String.class, factoryService.getPath());
        factoryBuilder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

