/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.Remote;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class BusinessViewAnnotationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(BusinessViewAnnotationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            Class<?> ejbClass = this.getEjbClass(componentDescription.getComponentClassName(), (ClassLoader)moduleClassLoader);
            this.processViewAnnotations(ejbClass, (SessionBeanComponentDescription)componentDescription);
        }
    }

    private void processViewAnnotations(Class<?> sessionBeanClass, SessionBeanComponentDescription sessionBeanComponentDescription) throws DeploymentUnitProcessingException {
        Collection<Class<?>> localBusinessInterfaces;
        Collection<Class<?>> remoteBusinessInterfaces = this.getRemoteBusinessInterfaces(sessionBeanClass);
        if (remoteBusinessInterfaces != null && !remoteBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addRemoteBusinessInterfaceViews(this.toString(remoteBusinessInterfaces));
        }
        if ((localBusinessInterfaces = this.getLocalBusinessInterfaces(sessionBeanClass)) != null && !localBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addLocalBusinessInterfaceViews(this.toString(localBusinessInterfaces));
        }
        if (BusinessViewAnnotationProcessor.hasNoInterfaceView(sessionBeanClass)) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (BusinessViewAnnotationProcessor.hasNoViews(sessionBeanComponentDescription)) {
            Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (potentialBusinessInterfaces.isEmpty()) {
                sessionBeanComponentDescription.addNoInterfaceView();
            } else if (potentialBusinessInterfaces.size() == 1) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(potentialBusinessInterfaces.iterator().next().getName());
            }
        }
    }

    private Collection<Class<?>> getRemoteBusinessInterfaces(Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Remote remoteViewAnnotation = sessionBeanClass.getAnnotation(Remote.class);
        if (remoteViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Remote.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] remoteViews = remoteViewAnnotation.value();
        if (remoteViews == null || remoteViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1) {
                throw new DeploymentUnitProcessingException("Bean " + sessionBeanClass + " specifies @Remote annotation, but does not implement 1 interface");
            }
            return interfaces;
        }
        return Arrays.asList(remoteViews);
    }

    private Collection<Class<?>> getLocalBusinessInterfaces(Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Local localViewAnnotation = sessionBeanClass.getAnnotation(Local.class);
        if (localViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Local.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] remoteViews = localViewAnnotation.value();
        if (remoteViews == null || remoteViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1) {
                throw new DeploymentUnitProcessingException("Bean " + sessionBeanClass + " specifies @Remote annotation, but does not implement 1 interface");
            }
            return interfaces;
        }
        return Arrays.asList(remoteViews);
    }

    private static Collection<Class<?>> getBusinessInterfacesFromInterfaceAnnotations(Class<?> sessionBeanClass, Class<? extends Annotation> annotation) {
        Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
        HashSet businessInterfaces = new HashSet();
        for (Class<?> iface : potentialBusinessInterfaces) {
            if (iface.getAnnotation(annotation) == null) continue;
            businessInterfaces.add(iface);
        }
        return businessInterfaces;
    }

    private static Set<Class<?>> getPotentialBusinessInterfaces(Class<?> sessionBeanClass) {
        return ViewInterfaces.getPotentialViewInterfaces(sessionBeanClass);
    }

    private static boolean hasNoInterfaceView(Class<?> sessionBeanClass) {
        return sessionBeanClass.getAnnotation(LocalBean.class) != null;
    }

    private static boolean hasNoViews(SessionBeanComponentDescription sessionBeanComponentDescription) {
        return sessionBeanComponentDescription.getViews() == null || sessionBeanComponentDescription.getViews().isEmpty();
    }

    private Class<?> getEjbClass(String className, ClassLoader cl) throws DeploymentUnitProcessingException {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load EJB class " + className, (Throwable)e);
        }
    }

    private Collection<String> toString(Collection<Class<?>> classes) {
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class<?> klass : classes) {
            classNames.add(klass.getName());
        }
        return classNames;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

