/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.concurrency;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.LockType;
import javax.interceptor.InvocationContext;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.concurrency.EJBReadWriteLock;
import org.jboss.as.ejb3.concurrency.LockableComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(ContainerManagedConcurrencyInterceptor.class);
    private final ReadWriteLock readWriteLock = new EJBReadWriteLock();
    private final LockableComponent lockableComponent;

    public ContainerManagedConcurrencyInterceptor(LockableComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(LockableComponent.class.getName() + " cannot be null");
        }
        this.lockableComponent = component;
    }

    protected LockableComponent getLockableComponent() {
        return this.lockableComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean success;
        InvocationContext invocationContext = context.getInvocationContext();
        LockableComponent lockableComponent = this.getLockableComponent();
        Method invokedMethod = invocationContext.getMethod();
        if (invokedMethod == null) {
            throw new IllegalArgumentException("Invocation context: " + invocationContext + " cannot be processed because it's not applicable for a method invocation");
        }
        Lock lock = this.getLock(lockableComponent, invokedMethod);
        AccessTimeoutDetails defaultAccessTimeout = lockableComponent.getDefaultAccessTimeout();
        long time = defaultAccessTimeout.getValue();
        TimeUnit unit = defaultAccessTimeout.getTimeUnit();
        AccessTimeoutDetails accessTimeoutOnMethod = lockableComponent.getAccessTimeout(invokedMethod);
        if (accessTimeoutOnMethod != null) {
            if (accessTimeoutOnMethod.getValue() < 0L) {
                logger.debug((Object)("Ignoring a negative @AccessTimeout value: " + accessTimeoutOnMethod.getValue() + " and timeout unit: " + accessTimeoutOnMethod.getTimeUnit().name() + ". Will default to timeout value: " + defaultAccessTimeout.getValue() + " and timeout unit: " + defaultAccessTimeout.getTimeUnit().name()));
            } else {
                time = accessTimeoutOnMethod.getValue();
                unit = accessTimeoutOnMethod.getTimeUnit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on " + invocationContext + " - could not obtain lock within " + time + unit.name());
        }
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(LockableComponent lockableComponent, Method method) {
        LockType lockType = lockableComponent.getLockType(method);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw new IllegalStateException("Illegal lock type " + lockType + " on " + method + " for component " + lockableComponent);
    }
}

