/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.context.spi.SessionContext;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public abstract class SessionBeanComponent
extends EJBComponent
implements org.jboss.as.ejb3.context.spi.SessionBeanComponent {
    private static final Logger logger = Logger.getLogger(SessionBeanComponent.class);
    public static final ServiceName ASYNC_EXECUTOR_SERVICE_NAME = ThreadsServices.EXECUTOR.append(new String[]{"ejb3-async"});
    protected final Map<String, AccessTimeoutDetails> beanLevelAccessTimeout;
    private final ExecutorService asyncExecutor;

    protected SessionBeanComponent(SessionBeanComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.beanLevelAccessTimeout = ejbComponentCreateService.getBeanAccessTimeout();
        this.asyncExecutor = (ExecutorService)ejbComponentCreateService.getAsyncExecutorService().getOptionalValue();
    }

    @Override
    public <T> T getBusinessObject(SessionContext ctx, Class<T> businessInterface) throws IllegalStateException {
        if (businessInterface == null) {
            throw new IllegalStateException("Business interface type cannot be null");
        }
        return this.createViewInstanceProxy(businessInterface, Collections.<Object, Object>emptyMap());
    }

    protected Serializable getSessionIdOf(SessionContext ctx) {
        return ((SessionBeanComponentInstance.SessionBeanComponentInstanceContext)ctx).getId();
    }

    @Override
    public EJBLocalObject getEJBLocalObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBLocalObject");
    }

    @Override
    public EJBObject getEJBObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBObject");
    }

    public ExecutorService getAsynchronousExecutor() {
        return this.asyncExecutor;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.2.9 getRollbackOnly is not allowed with SUPPORTS attribute");
        }
        return super.getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        if (this.getCurrentTransactionAttribute() == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.2.8 setRollbackOnly is not allowed with SUPPORTS attribute");
        }
        super.setRollbackOnly();
    }
}

