/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.TransactionAttributeType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstance;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.context.base.BaseInvocationContext;
import org.jboss.as.ejb3.context.spi.InvocationContext;
import org.jboss.as.ejb3.context.spi.MessageDrivenContext;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.ejb3.tx.TransactionalInvocationContext;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

class MessageDrivenInvocationContextInterceptor
implements Interceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new MessageDrivenInvocationContextInterceptor());

    private MessageDrivenInvocationContextInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Method method = context.getMethod();
        Object[] parameters = context.getParameters();
        CustomInvocationContext invocationContext = new CustomInvocationContext(context, method, parameters);
        context.putPrivateData(InvocationContext.class, (Object)invocationContext);
        CurrentInvocationContext.push(invocationContext);
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            CurrentInvocationContext.pop();
            context.putPrivateData(InvocationContext.class, null);
        }
    }

    protected static class CustomInvocationContext
    extends BaseInvocationContext
    implements TransactionalInvocationContext {
        private final InterceptorContext context;

        protected CustomInvocationContext(InterceptorContext context, Method method, Object[] parameters) {
            super(method, parameters);
            this.context = context;
        }

        @Override
        public ApplicationExceptionDetails getApplicationException(Class<?> e) {
            return this.getComponent().getApplicationException(e, this.getMethod());
        }

        @Override
        public Map<String, Object> getContextData() {
            return this.context.getContextData();
        }

        @Override
        public MessageDrivenComponent getComponent() {
            return (MessageDrivenComponent)this.context.getPrivateData(Component.class);
        }

        @Override
        public MessageDrivenContext getEJBContext() {
            return ((MessageDrivenComponentInstance)((Object)this.context.getPrivateData(ComponentInstance.class))).getMessageDrivenContext();
        }

        @Override
        public TransactionAttributeType getTransactionAttribute() {
            return this.getComponent().getTransactionAttributeType(this.getMethod());
        }

        @Override
        public int getTransactionTimeout() {
            return this.getComponent().getTransactionTimeout(this.getMethod());
        }

        @Override
        public Object proceed() throws Exception {
            return this.context.proceed();
        }

        @Override
        public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
            this.context.setParameters(params);
        }
    }
}

