/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public final class AsyncFutureInterceptorFactory
implements InterceptorFactory {
    public static final InterceptorFactory INSTANCE = new AsyncFutureInterceptorFactory();

    private AsyncFutureInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final SessionBeanComponent component = (SessionBeanComponent)context.getContextData().get(Component.class);
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                InterceptorContext asyncInterceptorContext = context.clone();
                CancellationFlag flag = new CancellationFlag();
                Task task = new Task(asyncInterceptorContext, flag);
                asyncInterceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
                component.getAsynchronousExecutor().execute(task);
                return task;
            }
        };
    }

    private static class Task
    implements Runnable,
    Future {
        private final InterceptorContext context;
        private final CancellationFlag cancelledFlag;
        private volatile boolean running = false;
        private boolean done = false;
        private Object result;
        private Exception failed;

        private Task(InterceptorContext context, CancellationFlag cancelledFlag) {
            this.context = context;
            this.cancelledFlag = cancelledFlag;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (!mayInterruptIfRunning && this.running) {
                return false;
            }
            this.cancelledFlag.set(true);
            if (!this.running) {
                this.done();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result;
            Task task = this;
            synchronized (task) {
                this.running = true;
                if (this.cancelledFlag.get()) {
                    return;
                }
            }
            try {
                result = this.context.proceed();
            }
            catch (Exception e) {
                this.setFailed(e);
                return;
            }
            Future asyncResult = (Future)result;
            try {
                if (asyncResult != null) {
                    result = asyncResult.get();
                }
            }
            catch (InterruptedException e) {
                this.setFailed(new IllegalStateException(e));
                return;
            }
            catch (ExecutionException e) {
                try {
                    throw e.getCause();
                }
                catch (Exception ex) {
                    this.setFailed(ex);
                    return;
                }
                catch (Throwable throwable) {
                    this.setFailed(new UndeclaredThrowableException(throwable));
                    return;
                }
            }
            this.setResult(result);
        }

        private synchronized void setResult(Object result) {
            this.result = result;
            this.done();
        }

        private synchronized void setFailed(Exception e) {
            this.failed = e;
            this.done();
        }

        private void done() {
            this.done = true;
            this.notifyAll();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelledFlag.get();
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        public synchronized Object get() throws InterruptedException, ExecutionException {
            while (!this.isDone()) {
                this.wait();
            }
            if (this.failed != null) {
                throw new ExecutionException(this.failed);
            }
            return this.result;
        }

        public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.isDone()) {
                this.wait(unit.toMillis(timeout));
                if (!this.isDone()) {
                    throw new TimeoutException("Task did not complete in " + timeout + " " + (Object)((Object)unit));
                }
            }
            if (this.cancelledFlag.get()) {
                throw new CancellationException("Task was cancelled");
            }
            if (this.failed != null) {
                throw new ExecutionException(this.failed);
            }
            return this.result;
        }
    }
}

