/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.logging.Logger;

public class ExpiringCache<T extends Identifiable>
implements Cache<T> {
    private static final long SLEEP_TIME = 500L;
    private final long millisecondTimeout;
    private final String beanName;
    private final Map<Object, Entry> cache;
    private volatile StatefulObjectFactory<T> factory;
    private volatile ExpirationTask expiryThread;
    private static final Logger logger = Logger.getLogger(ExpiringCache.class);

    public ExpiringCache(long value, TimeUnit timeUnit, String beanName) {
        this.beanName = beanName;
        this.millisecondTimeout = TimeUnit.MILLISECONDS.convert(value, timeUnit);
        this.cache = new HashMap<Object, Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() {
        Identifiable obj = (Identifiable)this.factory.createInstance();
        Entry entry = new Entry(this, obj);
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.put(obj.getId(), entry);
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(Serializable key) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Serializable key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry val = this.cache.get(key);
            if (val == null) {
                throw new NoSuchEJBException("Could not find EJB with id " + key);
            }
            val.lastUsed = System.currentTimeMillis();
            val.state = State.IN_USE;
            return val.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(obj.getId());
            if (entry == null) {
                logger.warn((Object)("Could not find stateful bean to release " + obj.getId()));
                return;
            }
            entry.lastUsed = System.currentTimeMillis();
            entry.state = State.INACTIVE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Serializable key) {
        Entry object;
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            object = this.cache.remove(key);
        }
        if (object == null) {
            throw new NoSuchEJBException(String.valueOf(key));
        }
        this.factory.destroyInstance(object.value);
    }

    @Override
    public void setStatefulObjectFactory(StatefulObjectFactory<T> tStatefulObjectFactory) {
        this.factory = tStatefulObjectFactory;
    }

    @Override
    public synchronized void start() {
        if (this.millisecondTimeout >= 0L) {
            this.expiryThread = new ExpirationTask();
            this.expiryThread.setDaemon(true);
            this.expiryThread.start();
            this.expiryThread.setName("Expiry Thread for SFSB " + this.beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.expiryThread != null) {
            this.expiryThread.stopTask();
        }
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    private static final class Entry {
        private long lastUsed;
        private State state = State.IN_USE;
        private final T value;
        final /* synthetic */ ExpiringCache this$0;

        public Entry(T value) {
            this.this$0 = var1_1;
            this.value = value;
            this.lastUsed = System.currentTimeMillis();
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public Serializable getKey() {
            return this.value.getId();
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public boolean isExpired(long currentTimeInMillis) {
            return this.state == State.INACTIVE && currentTimeInMillis > this.lastUsed + this.this$0.millisecondTimeout;
        }

        public T getValue() {
            return this.value;
        }
    }

    private static enum State {
        IN_USE,
        INACTIVE;

    }

    private class ExpirationTask
    extends Thread {
        private volatile boolean running = true;

        private ExpirationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                ArrayList queue = new ArrayList();
                long time = System.currentTimeMillis();
                Map map = ExpiringCache.this.cache;
                synchronized (map) {
                    Iterator iterator = ExpiringCache.this.cache.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!((Entry)entry.getValue()).isExpired(time)) continue;
                        queue.add(entry.getValue());
                        iterator.remove();
                    }
                }
                for (Entry value : queue) {
                    try {
                        logger.debugf("Removing stateful bean %s - %s as it has been inactive for %d milliseconds", (Object)ExpiringCache.this.beanName, (Object)value.getKey(), (Object)ExpiringCache.this.millisecondTimeout);
                        ExpiringCache.this.factory.destroyInstance(value.getValue());
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception removing stateful bean " + value.getKey()), (Throwable)e);
                    }
                }
                try {
                    ExpirationTask.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
            }
        }

        public void stopTask() {
            this.running = false;
        }
    }
}

