/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.ParallelExtensionAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;

class ModelControllerImpl
implements ModelController {
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ManagementResourceRegistration rootRegistration;
    private final Lock writeLock = new ReentrantLock();
    private final ContainerStateMonitor stateMonitor;
    private final RootResource model = new RootResource();
    private final ConfigurationPersister persister;
    private final ProcessType processType;
    private final RunningModeControl runningModeControl;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    private final ExecutorService executorService;
    private final ExpressionResolver expressionResolver;

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, ProcessType processType, RunningModeControl runningModeControl, OperationStepHandler prepareStep, ControlledProcessState processState, ExecutorService executorService, ExpressionResolver expressionResolver) {
        this.serviceRegistry = serviceRegistry;
        this.serviceTarget = serviceTarget;
        this.rootRegistration = rootRegistration;
        this.stateMonitor = stateMonitor;
        this.persister = persister;
        this.processType = processType;
        this.runningModeControl = runningModeControl;
        this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        this.processState = processState;
        this.serviceTarget.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)stateMonitor);
        this.executorService = executorService;
        this.expressionResolver = expressionResolver;
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        return this.internalExecute(operation, handler, control, attachments, this.prepareStep);
    }

    protected ModelNode internalExecute(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep) {
        boolean restartResourceServices;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        ModelNode headers = operation.has("operation-headers") ? operation.get("operation-headers") : null;
        boolean rollbackOnFailure = headers == null || !headers.hasDefined("rollback-on-runtime-failure") || headers.get("rollback-on-runtime-failure").asBoolean();
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        boolean bl = restartResourceServices = headers != null && headers.hasDefined("allow-resource-service-restart") && headers.get("allow-resource-service-restart").asBoolean();
        if (restartResourceServices) {
            contextFlags.add(AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
        }
        final ModelNode response = new ModelNode();
        ModelController.OperationTransactionControl originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, response);
            }
        };
        OperationContextImpl context = new OperationContextImpl(this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, attachments, this.model, originalResultTxControl, this.processState, this.bootingFlag.get());
        context.addStep(response, operation, prepareStep, OperationContext.Stage.MODEL);
        context.executeOperation();
        if (!response.hasDefined("response-headers") || !response.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    response.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        return response;
    }

    boolean boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control, boolean rollbackOnRuntimeFailure) {
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnRuntimeFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        OperationContextImpl context = new OperationContextImpl(this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.model, control, this.processState, this.bootingFlag.get());
        List<ParsedBootOp> postExtensionOps = this.organizeBootOperations(bootList, context);
        OperationContext.ResultAction resultAction = context.executeOperation();
        if (resultAction == OperationContext.ResultAction.KEEP && postExtensionOps != null) {
            OperationContextImpl postExtContext = new OperationContextImpl(this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.model, control, this.processState, this.bootingFlag.get());
            for (ParsedBootOp parsedOp : postExtensionOps) {
                OperationStepHandler stepHandler;
                OperationStepHandler operationStepHandler = stepHandler = parsedOp.handler == null ? this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName) : parsedOp.handler;
                if (stepHandler == null) {
                    this.logNoHandler(parsedOp);
                    postExtContext.setRollbackOnly();
                    break;
                }
                postExtContext.addStep(parsedOp.response, parsedOp.operation, stepHandler, OperationContext.Stage.MODEL);
            }
            resultAction = postExtContext.executeOperation();
        }
        return resultAction == OperationContext.ResultAction.KEEP;
    }

    private List<ParsedBootOp> organizeBootOperations(List<ModelNode> bootList, OperationContextImpl context) {
        ModelNode result = new ModelNode().setEmptyList();
        boolean sawExtensionAdd = false;
        ArrayList<ParsedBootOp> postExtensionOps = null;
        ParallelExtensionAddHandler parallelExtensionAddHandler = this.executorService == null ? null : new ParallelExtensionAddHandler(this.executorService);
        ParallelBootOperationStepHandler parallelSubsystemHandler = this.executorService != null && this.processType.isServer() && this.runningModeControl.getRunningMode() == RunningMode.NORMAL ? new ParallelBootOperationStepHandler(this.executorService, this.rootRegistration, this.processState) : null;
        boolean registeredParallelSubsystemHandler = false;
        int subsystemIndex = 0;
        for (ModelNode bootOp : bootList) {
            ModelNode op;
            OperationStepHandler stepHandler;
            ParsedBootOp parsedOp = new ParsedBootOp(bootOp, result.add());
            if (postExtensionOps != null) {
                if (parsedOp.isExtensionAdd()) {
                    stepHandler = (ExtensionAddHandler)this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
                    if (parallelExtensionAddHandler != null) {
                        parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                        continue;
                    }
                    context.addStep(parsedOp.response, parsedOp.operation, stepHandler, OperationContext.Stage.MODEL);
                    continue;
                }
                if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                    if (registeredParallelSubsystemHandler && (parsedOp.isInterfaceOperation() || parsedOp.isSocketOperation())) {
                        postExtensionOps.add(subsystemIndex++, parsedOp);
                        continue;
                    }
                    postExtensionOps.add(parsedOp);
                    continue;
                }
                if (registeredParallelSubsystemHandler) continue;
                ModelNode op2 = Util.getEmptyOperation("parallel-subsystem-boot", new ModelNode().setEmptyList());
                postExtensionOps.add(new ParsedBootOp(op2, parallelSubsystemHandler, result.add()));
                subsystemIndex = postExtensionOps.size() - 1;
                registeredParallelSubsystemHandler = true;
                continue;
            }
            stepHandler = this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
            if (!sawExtensionAdd && stepHandler == null) {
                this.logNoHandler(parsedOp);
                context.setRollbackOnly();
                break;
            }
            if (stepHandler instanceof ExtensionAddHandler) {
                if (parallelExtensionAddHandler != null) {
                    parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                    if (!sawExtensionAdd) {
                        op = Util.getEmptyOperation("parallel-extension-add", new ModelNode().setEmptyList());
                        context.addStep(result.add(), op, parallelExtensionAddHandler, OperationContext.Stage.MODEL);
                    }
                } else {
                    context.addStep(parsedOp.response, parsedOp.operation, stepHandler, OperationContext.Stage.MODEL);
                }
                sawExtensionAdd = true;
                continue;
            }
            if (!sawExtensionAdd) {
                context.addStep(result.add(), bootOp, stepHandler, OperationContext.Stage.MODEL);
                continue;
            }
            postExtensionOps = new ArrayList<ParsedBootOp>();
            if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                postExtensionOps.add(parsedOp);
                continue;
            }
            op = Util.getEmptyOperation("parallel-subsystem-boot", new ModelNode().setEmptyList());
            postExtensionOps.add(new ParsedBootOp(op, parallelSubsystemHandler, result.add()));
            registeredParallelSubsystemHandler = true;
        }
        return postExtensionOps;
    }

    void finishBoot() {
        this.bootingFlag.set(false);
    }

    public Resource getRootResource() {
        return this.model;
    }

    ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    @Override
    public ModelControllerClient createClient(final Executor executor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        return new ModelControllerClient(){

            public void close() throws IOException {
            }

            public ModelNode execute(ModelNode operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(Operation operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, null);
            }

            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation.getOperation(), messageHandler, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation);
            }

            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation, messageHandler, null);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation);
            }

            private AsyncFuture<ModelNode> executeAsync(final ModelNode operation, final OperationMessageHandler messageHandler, final OperationAttachments attachments) {
                if (executor == null) {
                    throw ControllerMessages.MESSAGES.nullAsynchronousExecutor();
                }
                final AtomicReference opThread = new AtomicReference();
                class OpTask
                extends AsyncFutureTask<ModelNode> {
                    OpTask() {
                        super(executor);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void asyncCancel(boolean interruptionDesired) {
                        Thread thread = opThread.getAndSet(Thread.currentThread());
                        if (thread == null) {
                            this.setCancelled();
                        } else {
                            thread.interrupt();
                            boolean interrupted = false;
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                while (opThread.get() != null) {
                                    try {
                                        opThread.wait();
                                    }
                                    catch (InterruptedException ie) {
                                        interrupted = true;
                                    }
                                }
                            }
                            this.setCancelled();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }

                    void handleResult(ModelNode result) {
                        if (result != null && result.hasDefined("outcome") && "cancelled".equals(result.get("outcome").asString())) {
                            this.setCancelled();
                        } else {
                            this.setResult(result);
                        }
                    }
                }
                final OpTask opTask = new OpTask();
                executor.execute(new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (opThread.compareAndSet(null, Thread.currentThread())) {
                                ModelNode response = ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, attachments);
                                opTask.handleResult(response);
                            }
                        }
                        finally {
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                opThread.set(null);
                                opThread.notifyAll();
                            }
                        }
                    }
                });
                return opTask;
            }
        };
    }

    ConfigurationPersister.PersistenceResource writeModel(final Resource resource, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        ModelNode newModel = Resource.Tools.readModel(resource);
        final ConfigurationPersister.PersistenceResource delegate = this.persister.store(newModel, affectedAddresses);
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                ModelControllerImpl.this.model.set(resource);
                delegate.commit();
            }

            @Override
            public void rollback() {
                delegate.rollback();
            }
        };
    }

    void acquireLock(boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.writeLock.lockInterruptibly();
        } else {
            this.writeLock.lock();
        }
    }

    void releaseLock() {
        this.writeLock.unlock();
    }

    void acquireContainerMonitor() {
        this.stateMonitor.acquire();
    }

    void releaseContainerMonitor() {
        this.stateMonitor.release();
    }

    void awaitContainerMonitor(boolean interruptibly, int count) throws InterruptedException {
        if (interruptibly) {
            this.stateMonitor.await(count);
        } else {
            this.stateMonitor.awaitUninterruptibly(count);
        }
    }

    ContainerStateMonitor.ContainerStateChangeReport awaitContainerStateChangeReport(int count) throws InterruptedException {
        return this.stateMonitor.awaitContainerStateChangeReport(count);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.expressionResolver.resolveExpressions(node);
    }

    private void logNoHandler(ParsedBootOp parsedOp) {
        ManagementResourceRegistration child = this.rootRegistration.getSubModel(parsedOp.address);
        if (child == null) {
            ControllerLogger.ROOT_LOGGER.noSuchResourceType(parsedOp.address);
        } else {
            ControllerLogger.ROOT_LOGGER.noHandlerForOperation(parsedOp.operationName, parsedOp.address);
        }
    }

    private final class RootResource
    implements Resource {
        private final AtomicReference<Resource> modelReference = new AtomicReference<Resource>(Resource.Factory.create());

        private RootResource() {
        }

        void set(Resource resource) {
            this.modelReference.set(resource);
        }

        @Override
        public Resource clone() {
            return this.getDelegate().clone();
        }

        @Override
        public Resource getChild(PathElement element) {
            return this.getDelegate().getChild(element);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return this.getDelegate().getChildren(childType);
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.getDelegate().getChildrenNames(childType);
        }

        @Override
        public Set<String> getChildTypes() {
            return this.getDelegate().getChildTypes();
        }

        @Override
        public ModelNode getModel() {
            return this.getDelegate().getModel();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.getDelegate().hasChild(element);
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.getDelegate().hasChildren(childType);
        }

        @Override
        public boolean isModelDefined() {
            return this.getDelegate().isModelDefined();
        }

        @Override
        public boolean isProxy() {
            return this.getDelegate().isProxy();
        }

        @Override
        public boolean isRuntime() {
            return this.getDelegate().isRuntime();
        }

        @Override
        public Resource navigate(PathAddress address) {
            return this.getDelegate().navigate(address);
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            this.getDelegate().registerChild(address, resource);
        }

        @Override
        public Resource removeChild(PathElement address) {
            return this.getDelegate().removeChild(address);
        }

        @Override
        public Resource requireChild(PathElement element) {
            return this.getDelegate().requireChild(element);
        }

        @Override
        public void writeModel(ModelNode newModel) {
            this.getDelegate().writeModel(newModel);
        }

        private Resource getDelegate() {
            return this.modelReference.get();
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.trace("Executing " + operation.get("operation") + " " + operation.get("address"));
            }
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            String operationName = operation.require("operation").asString();
            OperationStepHandler stepHandler = ModelControllerImpl.this.rootRegistration.getOperationHandler(address, operationName);
            if (stepHandler != null) {
                context.addStep(stepHandler, OperationContext.Stage.MODEL);
            } else {
                ManagementResourceRegistration child = ModelControllerImpl.this.rootRegistration.getSubModel(address);
                if (child == null) {
                    context.getFailureDescription().set(ControllerMessages.MESSAGES.noSuchResourceType(address));
                } else {
                    context.getFailureDescription().set(ControllerMessages.MESSAGES.noHandlerForOperation(operationName, address));
                }
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

