/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;

public class ManagementDescription {
    private static final String RESOURCE_NAME = ManagementDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, ManagementDescription.class.getClassLoader(), true, false);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static ModelNode getManagementDescriptionWithInterfaces(Locale locale) {
        return ManagementDescription.getManagementDescription(locale, true);
    }

    public static ModelNode getManagementDescription(Locale locale, boolean interfaces) {
        ResourceBundle bundle2 = ManagementDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("core.management"));
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "security-realm", "description"}).set(bundle2.getString("core.management.security-realms"));
        root.get(new String[]{"children", "security-realm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "security-realm", "model-description"});
        root.get(new String[]{"children", "ldap-connection", "description"}).set(bundle2.getString("core.management.ldap-connections"));
        root.get(new String[]{"children", "ldap-connection", "min-occurs"}).set(0);
        root.get(new String[]{"children", "ldap-connection", "model-description"});
        if (interfaces) {
            root.get(new String[]{"children", "management-interface", "description"}).set(bundle2.getString("core.management.management-interfaces"));
            root.get(new String[]{"children", "management-interface", "min-occurs"}).set(0);
            root.get(new String[]{"children", "management-interface", "model-description"});
        }
        return root;
    }
}

