/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;

public class SimpleListAttributeDefinition
extends ListAttributeDefinition {
    private final SimpleAttributeDefinition valueType;

    private SimpleListAttributeDefinition(String name, String xmlName, SimpleAttributeDefinition valueType, boolean allowNull, int minSize, int maxSize, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        super(name, xmlName, allowNull, minSize, maxSize, valueType.getValidator(), alternatives, requires, flags);
        this.valueType = valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        node.get(new String[]{"value-type", this.valueType.getName()}).set(this.getValueTypeDescription(false));
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(false);
        valueTypeDesc.get("description").set(this.valueType.getAttributeTextDescription(bundle2, prefix));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(false);
        valueTypeDesc.get("description").set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, this.valueType.getName()));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(true);
        valueTypeDesc.get("description").set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, this.valueType.getName()));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName())) {
            writer.writeStartElement(this.getXmlName());
            for (ModelNode handler : resourceModel.get(this.getName()).asList()) {
                this.valueType.marshallAsElement(handler, writer);
            }
            writer.writeEndElement();
        }
    }

    private ModelNode getValueTypeDescription(boolean forOperation) {
        AllowedValuesValidator avv;
        List<ModelNode> allowed;
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(this.valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(this.valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.valueType.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        if (validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)((Object)validator)).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
        return result;
    }

    public static class Builder {
        private final String name;
        private final SimpleAttributeDefinition valueType;
        private String xmlName;
        private boolean allowNull;
        private int minSize;
        private int maxSize;
        private String[] alternatives;
        private String[] requires;
        private AttributeAccess.Flag[] flags;

        public Builder(String name, SimpleAttributeDefinition valueType) {
            this.name = name;
            this.valueType = valueType;
        }

        public static Builder of(String name, SimpleAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        public SimpleListAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            return new SimpleListAttributeDefinition(this.name, this.xmlName, this.valueType, this.allowNull, this.minSize, this.maxSize, this.alternatives, this.requires, this.flags);
        }

        public Builder setAllowNull(boolean allowNull) {
            this.allowNull = allowNull;
            return this;
        }

        public Builder setAlternates(String ... alternates) {
            this.alternatives = alternates;
            return this;
        }

        public Builder setFlags(AttributeAccess.Flag ... flags) {
            this.flags = flags;
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder setRequires(String ... requires) {
            this.requires = requires;
            return this;
        }

        public Builder setXmlName(String xmlName) {
            this.xmlName = xmlName;
            return this;
        }
    }
}

