/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.Closeable;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface ControllerLogger
extends BasicLogger {
    public static final ControllerLogger ROOT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)ControllerLogger.class.getPackage().getName());
    public static final ControllerLogger MGMT_OP_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)(ControllerLogger.class.getPackage().getName() + ".management-operation"));
    public static final ControllerLogger SERVER_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.server");
    public static final ControllerLogger SERVER_MANAGEMENT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.server.management");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14600, value="Cannot resolve address %s, so cannot match it to any InetAddress")
    public void cannotResolveAddress(ModelNode var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14601, value="Error booting the container")
    public void errorBootingContainer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14602, value="Error booting the container due to insufficient stack space for the thread used to execute boot operations. The thread was configured with a stack size of [%1$d]. Setting system property %2$s to a value higher than [%1$d] may resolve this problem.")
    public void errorBootingContainer(@Cause Throwable var1, long var2, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14603, value="%s caught exception attempting to revert operation %s at address %s")
    public void errorRevertingOperation(@Cause Throwable var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14604, value="Failed executing operation %s at address %s")
    public void failedExecutingOperation(@Cause Throwable var1, ModelNode var2, PathAddress var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14605, value="Failed executing subsystem %s boot operations")
    public void failedSubsystemBootOperations(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14606, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Closeable var2);

    @LogMessage(level=Logger.Level.ERROR)
    public void failedToCloseResource(@Cause Throwable var1, XMLStreamWriter var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14607, value="Failed to persist configuration change")
    public void failedToPersistConfigurationChange(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14608, value="Failed to store configuration to %s")
    public void failedToStoreConfiguration(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14609, value="Invalid value %s for system property %s -- using default value [%d]")
    public void invalidSystemPropertyValue(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14610, value="Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration element to specify that an interface should use a wildcard address; use '%3$s', '%4$s', or '%5$s'")
    public void invalidWildcardAddress(ModelNode var1, String var2, String var3, String var4, String var5);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14611, value="No handler for %s at address %s")
    public void noHandler(String var1, PathAddress var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14612, value="Operation (%s) failed - address: (%s)")
    public void operationFailed(@Cause Throwable var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=-1, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailed(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14613, value="Operation (%s) failed - address: (%s) -- due to insufficient stack space for the thread used to execute operations. If this error is occurring during server boot, setting system property %s to a value higher than [%d] may resolve this problem.")
    public void operationFailed(@Cause Throwable var1, ModelNode var2, ModelNode var3, String var4, int var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14614, value="Wildcard address detected - will ignore other interface criteria.")
    public void wildcardAddressDetected();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14615, value="Received no final outcome response for operation %s with address %s from remote process at address %s. The result of this operation will only include the remote process' preliminary response tothe request.")
    public void noFinalProxyOutcomeReceived(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14616, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailedOnClientError(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14617, value="A subystem '%s' was registered without calling ExtensionContext.createTracker(). The subsystems are registered normally but won't be cleaned up when the extension is removed.")
    public void registerSubsystemNoWraper(String var1);
}

