/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.JVMDescriptions;
import org.jboss.as.controller.operations.common.JVMAddHandler;
import org.jboss.as.controller.operations.common.JVMRemoveHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public final class JVMHandlers {
    public static final DescriptionProvider SERVER_MODEL_PROVIDER = new DescriptionProvider(){

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return JVMDescriptions.getServerJVMDescription(locale);
        }
    };
    public static final String JVM_AGENT_LIB = "agent-lib";
    public static final String JVM_AGENT_PATH = "agent-path";
    public static final String JVM_DEBUG_ENABLED = "debug-enabled";
    public static final String JVM_DEBUG_OPTIONS = "debug-options";
    public static final String JVM_ENV_CLASSPATH_IGNORED = "env-classpath-ignored";
    public static final String JVM_ENV_VARIABLES = "environment-variables";
    public static final String JVM_HEAP = "heap-size";
    public static final String JVM_MAX_HEAP = "max-heap-size";
    public static final String JVM_JAVA_AGENT = "java-agent";
    public static final String JVM_JAVA_HOME = "java-home";
    public static final String JVM_OPTIONS = "jvm-options";
    public static final String JVM_OPTION = "jvm-option";
    public static final String ADD_JVM_OPTION = "add-jvm-option";
    public static final String JVM_PERMGEN = "permgen-size";
    public static final String JVM_MAX_PERMGEN = "max-permgen-size";
    public static final String JVM_STACK = "stack-size";
    public static final String SIZE = "size";
    public static final String MAX_SIZE = "max-size";
    static final String[] ATTRIBUTES = new String[]{"agent-lib", "agent-path", "env-classpath-ignored", "environment-variables", "heap-size", "max-heap-size", "java-agent", "java-home", "jvm-options", "permgen-size", "max-permgen-size", "stack-size"};
    static final String[] SERVER_ATTRIBUTES = new String[]{"debug-enabled", "debug-options"};
    private static final OperationStepHandler writeHandler = WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE;
    private static final OperationStepHandler booleanWriteHandler = new OperationStepHandler(){

        @Override
        public void execute(OperationContext context, ModelNode operation) {
            String name = operation.require("name").asString();
            boolean value = operation.get("value").asBoolean();
            context.readModelForUpdate(PathAddress.EMPTY_ADDRESS).get(name).set(value);
            context.completeStep();
        }
    };

    public static void register(ManagementResourceRegistration registration) {
        JVMHandlers.register(registration, false);
    }

    public static void register(ManagementResourceRegistration registration, boolean server) {
        registration.registerOperationHandler("add", (OperationStepHandler)JVMAddHandler.INSTANCE, (DescriptionProvider)JVMAddHandler.INSTANCE, false);
        registration.registerOperationHandler("remove", (OperationStepHandler)JVMRemoveHandler.INSTANCE, (DescriptionProvider)JVMRemoveHandler.INSTANCE, false);
        registration.registerReadWriteAttribute(JVM_AGENT_LIB, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_AGENT_PATH, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        if (server) {
            registration.registerReadWriteAttribute(JVM_DEBUG_ENABLED, null, booleanWriteHandler, AttributeAccess.Storage.CONFIGURATION);
            registration.registerReadWriteAttribute(JVM_DEBUG_OPTIONS, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        }
        registration.registerReadWriteAttribute(JVM_ENV_CLASSPATH_IGNORED, null, booleanWriteHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_ENV_VARIABLES, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_HEAP, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_MAX_HEAP, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_JAVA_AGENT, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_JAVA_HOME, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_PERMGEN, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_MAX_PERMGEN, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_STACK, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerOperationHandler(ADD_JVM_OPTION, (OperationStepHandler)JVMOptionAddHandler.INSTANCE, (DescriptionProvider)JVMOptionAddHandler.INSTANCE, false);
        registration.registerOperationHandler("remove-jvm-option", (OperationStepHandler)JVMOptionRemoveHandler.INSTANCE, (DescriptionProvider)JVMOptionRemoveHandler.INSTANCE, false);
    }

    private JVMHandlers() {
    }

    static final class JVMOptionRemoveHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final String OPERATION_NAME = "remove-jvm-option";
        static final JVMOptionRemoveHandler INSTANCE = new JVMOptionRemoveHandler();
        private final ParameterValidator validator = new StringLengthValidator(1);

        JVMOptionRemoveHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validateParameter(JVMHandlers.JVM_OPTION, operation.get(JVMHandlers.JVM_OPTION));
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode model = resource.getModel();
            ModelNode option = operation.require(JVMHandlers.JVM_OPTION);
            if (model.hasDefined(JVMHandlers.JVM_OPTIONS)) {
                ModelNode values = model.get(JVMHandlers.JVM_OPTIONS);
                model.get(JVMHandlers.JVM_OPTIONS).setEmptyList();
                for (ModelNode value : values.asList()) {
                    if (value.equals(option)) continue;
                    model.get(JVMHandlers.JVM_OPTIONS).add(value);
                }
            }
            context.completeStep();
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return JVMDescriptions.getOptionRemoveOperation(locale);
        }
    }

    static final class JVMOptionAddHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final String OPERATION_NAME = "add-jvm-option";
        static final JVMOptionAddHandler INSTANCE = new JVMOptionAddHandler();
        private final ParameterValidator validator = new StringLengthValidator(1);

        JVMOptionAddHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validateParameter(JVMHandlers.JVM_OPTION, operation.get(JVMHandlers.JVM_OPTION));
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode model = resource.getModel();
            ModelNode option = operation.require(JVMHandlers.JVM_OPTION);
            model.get(JVMHandlers.JVM_OPTIONS).add(option);
            context.completeStep();
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return JVMDescriptions.getOptionAddOperation(locale);
        }
    }
}

