/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.InterfaceCriteria;

public class SubnetMatchInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = 149404752878332750L;
    private byte[] network;
    private int mask;

    public SubnetMatchInterfaceCriteria(byte[] network, int mask) {
        if (network == null) {
            throw ControllerMessages.MESSAGES.nullVar("network");
        }
        this.network = network;
        this.mask = mask;
    }

    @Override
    public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        byte[] addr = address.getAddress();
        if (addr.length != this.network.length) {
            return null;
        }
        int last = addr.length - this.mask;
        for (int i = 0; i < last; ++i) {
            if (addr[i] == this.network[i]) continue;
            return null;
        }
        return address;
    }
}

