/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.List;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

class ParallelBootOperationContext
extends AbstractOperationContext {
    private final OperationContext primaryContext;
    private final List<ParsedBootOp> runtimeOps;

    ParallelBootOperationContext(ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, OperationContext primaryContext, List<ParsedBootOp> runtimeOps, Thread controllingThread) {
        super(primaryContext.getProcessType(), primaryContext.getRunningMode(), transactionControl, processState, true);
        this.primaryContext = primaryContext;
        this.runtimeOps = runtimeOps;
        AbstractOperationContext.controllingThread.set(controllingThread);
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        if (this.activeStep == null) {
            throw ControllerMessages.MESSAGES.noActiveStep();
        }
        this.addStep(this.activeStep.response, this.activeStep.operation, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        if (this.activeStep == null) {
            throw ControllerMessages.MESSAGES.noActiveStep();
        }
        this.addStep(this.activeStep.response, operation, step, stage);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        switch (stage) {
            case MODEL: 
            case IMMEDIATE: {
                super.addStep(response, operation, step, stage);
                break;
            }
            case RUNTIME: {
                if (this.runtimeOps != null) {
                    ParsedBootOp parsedOp = new ParsedBootOp(operation, step, response);
                    this.runtimeOps.add(parsedOp);
                    break;
                }
                super.addStep(response, operation, step, stage);
                break;
            }
            default: {
                this.primaryContext.addStep(response, operation, step, stage);
            }
        }
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        return this.primaryContext.getAttachmentStream(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.primaryContext.getAttachmentStreamCount();
    }

    @Override
    public boolean isRollbackOnRuntimeFailure() {
        return this.primaryContext.isRollbackOnRuntimeFailure();
    }

    @Override
    public boolean isResourceServiceRestartAllowed() {
        return this.primaryContext.isResourceServiceRestartAllowed();
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        ImmutableManagementResourceRegistration parent = this.primaryContext.getResourceRegistration();
        return parent.getSubModel(this.activeStep.address);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        ManagementResourceRegistration parent = this.primaryContext.getResourceRegistrationForUpdate();
        return parent.getSubModel(this.activeStep.address);
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        return this.primaryContext.getServiceRegistry(modify);
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        return this.primaryContext.removeService(name);
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        this.primaryContext.removeService(controller);
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        return this.primaryContext.getServiceTarget();
    }

    @Override
    public ModelNode readModel(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readModel(fullAddress);
    }

    @Override
    public ModelNode readModelForUpdate(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readModelForUpdate(fullAddress);
    }

    @Override
    public void acquireControllerLock() {
    }

    @Override
    public Resource createResource(PathAddress address) throws UnsupportedOperationException {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.createResource(fullAddress);
    }

    @Override
    public void addResource(PathAddress address, Resource toAdd) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        this.primaryContext.addResource(fullAddress, toAdd);
    }

    @Override
    public Resource readResource(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResource(fullAddress);
    }

    @Override
    public Resource readResourceForUpdate(PathAddress address) {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.readResourceForUpdate(fullAddress);
    }

    @Override
    public Resource removeResource(PathAddress address) throws UnsupportedOperationException {
        PathAddress fullAddress = this.activeStep.address.append(address);
        return this.primaryContext.removeResource(fullAddress);
    }

    @Override
    public Resource getRootResource() {
        return this.primaryContext.getRootResource();
    }

    @Override
    public Resource getOriginalRootResource() {
        return this.primaryContext.getOriginalRootResource();
    }

    @Override
    public boolean isModelAffected() {
        return this.primaryContext.isModelAffected();
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.primaryContext.isResourceRegistryAffected();
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.primaryContext.isRuntimeAffected();
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.primaryContext.getCurrentStage();
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        this.primaryContext.report(severity, message);
    }

    @Override
    public boolean markResourceRestarted(PathAddress resource, Object owner) {
        throw new UnsupportedOperationException("Resource restarting is not supported during boot");
    }

    @Override
    public boolean revertResourceRestarted(PathAddress resource, Object owner) {
        throw new UnsupportedOperationException("Resource restarting is not supported during boot");
    }

    @Override
    void awaitModelControllerContainerMonitor() throws InterruptedException {
    }

    @Override
    ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException {
        return null;
    }

    @Override
    void releaseStepLocks(AbstractOperationContext.Step step) {
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.primaryContext.resolveExpressions(node);
    }

    @Override
    public <T> T getAttachment(OperationContext.AttachmentKey<T> key) {
        return this.primaryContext.getAttachment(key);
    }

    @Override
    public <T> T attach(OperationContext.AttachmentKey<T> key, T value) {
        return this.primaryContext.attach(key, value);
    }

    @Override
    public <T> T attachIfAbsent(OperationContext.AttachmentKey<T> key, T value) {
        return this.primaryContext.attachIfAbsent(key, value);
    }

    @Override
    public <T> T detach(OperationContext.AttachmentKey<T> key) {
        return this.primaryContext.detach(key);
    }
}

