/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;

abstract class AbstractResourceRegistration
implements ManagementResourceRegistration {
    private final String valueString;
    private final NodeSubregistry parent;

    AbstractResourceRegistration(String valueString, NodeSubregistry parent) {
        this.valueString = valueString;
        this.parent = parent;
    }

    @Override
    public abstract ManagementResourceRegistration registerSubModel(PathElement var1, DescriptionProvider var2);

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, false);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, inherited, OperationEntry.EntryType.PUBLIC);
    }

    @Override
    public abstract void registerOperationHandler(String var1, OperationStepHandler var2, DescriptionProvider var3, boolean var4, OperationEntry.EntryType var5);

    @Override
    public abstract void registerOperationHandler(String var1, OperationStepHandler var2, DescriptionProvider var3, boolean var4, OperationEntry.EntryType var5, EnumSet<OperationEntry.Flag> var6);

    @Override
    public abstract void registerProxyController(PathElement var1, ProxyController var2) throws IllegalArgumentException;

    @Override
    public abstract void unregisterProxyController(PathElement var1);

    @Override
    public final OperationStepHandler getOperationHandler(PathAddress pathAddress, String operationName) {
        OperationStepHandler inheritable = this.getInheritableOperationHandler(operationName);
        OperationStepHandler result = this.getOperationHandler((ListIterator<PathElement>)pathAddress.iterator(), operationName, inheritable);
        NodeSubregistry ancestorSubregistry = this.parent;
        while (result == null && ancestorSubregistry != null) {
            AbstractResourceRegistration ancestor = ancestorSubregistry.getParent();
            result = ancestor.getInheritableOperationHandler(operationName);
            ancestorSubregistry = ancestor.parent;
        }
        return result;
    }

    abstract OperationStepHandler getOperationHandler(ListIterator<PathElement> var1, String var2, OperationStepHandler var3);

    abstract OperationStepHandler getInheritableOperationHandler(String var1);

    @Override
    public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
        return this.getAttributeAccess((ListIterator<PathElement>)address.iterator(), attributeName);
    }

    abstract AttributeAccess getAttributeAccess(ListIterator<PathElement> var1, String var2);

    @Override
    public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
        TreeMap<String, OperationEntry> providers = new TreeMap<String, OperationEntry>();
        this.getOperationDescriptions((ListIterator<PathElement>)address.iterator(), providers, inherited);
        return providers;
    }

    abstract void getOperationDescriptions(ListIterator<PathElement> var1, Map<String, OperationEntry> var2, boolean var3);

    @Override
    public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
        DescriptionProvider inheritable = this.getInheritableOperationDescription(operationName);
        DescriptionProvider result = this.getOperationDescription(address.iterator(), operationName, inheritable);
        NodeSubregistry ancestorSubregistry = this.parent;
        while (result == null && ancestorSubregistry != null) {
            AbstractResourceRegistration ancestor = ancestorSubregistry.getParent();
            result = ancestor.getInheritableOperationDescription(operationName);
            ancestorSubregistry = ancestor.parent;
        }
        return result;
    }

    abstract DescriptionProvider getOperationDescription(Iterator<PathElement> var1, String var2, DescriptionProvider var3);

    abstract DescriptionProvider getInheritableOperationDescription(String var1);

    @Override
    public final Set<OperationEntry.Flag> getOperationFlags(PathAddress pathAddress, String operationName) {
        Set<OperationEntry.Flag> inheritable = this.getInheritableOperationFlags(operationName);
        Set<OperationEntry.Flag> result = this.getOperationFlags((ListIterator<PathElement>)pathAddress.iterator(), operationName, inheritable);
        NodeSubregistry ancestorSubregistry = this.parent;
        while (result == null && ancestorSubregistry != null) {
            AbstractResourceRegistration ancestor = ancestorSubregistry.getParent();
            result = ancestor.getInheritableOperationFlags(operationName);
            ancestorSubregistry = ancestor.parent;
        }
        return result;
    }

    abstract Set<OperationEntry.Flag> getOperationFlags(ListIterator<PathElement> var1, String var2, Set<OperationEntry.Flag> var3);

    abstract Set<OperationEntry.Flag> getInheritableOperationFlags(String var1);

    @Override
    public DescriptionProvider getModelDescription(PathAddress address) {
        return this.getModelDescription(address.iterator());
    }

    abstract DescriptionProvider getModelDescription(Iterator<PathElement> var1);

    @Override
    public Set<String> getAttributeNames(PathAddress address) {
        return this.getAttributeNames(address.iterator());
    }

    abstract Set<String> getAttributeNames(Iterator<PathElement> var1);

    @Override
    public Set<String> getChildNames(PathAddress address) {
        return this.getChildNames(address.iterator());
    }

    abstract Set<String> getChildNames(Iterator<PathElement> var1);

    @Override
    public Set<PathElement> getChildAddresses(PathAddress address) {
        return this.getChildAddresses(address.iterator());
    }

    abstract Set<PathElement> getChildAddresses(Iterator<PathElement> var1);

    @Override
    public ProxyController getProxyController(PathAddress address) {
        return this.getProxyController(address.iterator());
    }

    abstract ProxyController getProxyController(Iterator<PathElement> var1);

    @Override
    public Set<ProxyController> getProxyControllers(PathAddress address) {
        HashSet<ProxyController> controllers = new HashSet<ProxyController>();
        this.getProxyControllers(address.iterator(), controllers);
        return controllers;
    }

    abstract void getProxyControllers(Iterator<PathElement> var1, Set<ProxyController> var2);

    @Override
    public ManagementResourceRegistration getSubModel(PathAddress address) {
        return this.getResourceRegistration(address.iterator());
    }

    abstract ManagementResourceRegistration getResourceRegistration(Iterator<PathElement> var1);

    final String getValueString() {
        return this.valueString;
    }

    final String getLocationString() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getLocationString() + this.valueString + ")";
    }

    void getInheritedOperations(Map<String, OperationEntry> providers, boolean skipSelf) {
        if (!skipSelf) {
            this.getInheritedOperationEntries(providers);
        }
        if (this.parent != null) {
            this.parent.getParent().getInheritedOperations(providers, false);
        }
    }

    abstract void getInheritedOperationEntries(Map<String, OperationEntry> var1);
}

