/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.dmr.ModelNode;

public class ProxyStepHandler
implements OperationStepHandler {
    private final ProxyController proxyController;

    public ProxyStepHandler(ProxyController proxyController) {
        this.proxyController = proxyController;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) {
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(context);
        final AtomicReference txRef = new AtomicReference();
        final AtomicReference preparedResultRef = new AtomicReference();
        final AtomicReference finalResultRef = new AtomicReference();
        ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                txRef.set(transaction);
                preparedResultRef.set(result);
            }

            @Override
            public void operationFailed(ModelNode response) {
                finalResultRef.set(response);
            }

            @Override
            public void operationCompleted(ModelNode response) {
                finalResultRef.set(response);
            }
        };
        this.proxyController.execute(operation, messageHandler, proxyControl, new DelegatingOperationAttachments(context));
        ModelNode finalResult = (ModelNode)finalResultRef.get();
        if (finalResult != null) {
            context.getResult().set(finalResult.get("result"));
            context.getFailureDescription().set(finalResult.get("failure-description"));
            context.completeStep();
        } else {
            ModelNode preparedResult = (ModelNode)preparedResultRef.get();
            context.getResult().set(preparedResult.get("result"));
            if (preparedResult.hasDefined("failure-description")) {
                context.getFailureDescription().set(preparedResult.get("failure-description"));
            }
            OperationContext.ResultAction resultAction = context.completeStep();
            ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
            if (tx != null) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    tx.commit();
                } else {
                    tx.rollback();
                }
            }
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }
}

