/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public class SocketBindingGroupIncludeAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add-include";
    public static final SocketBindingGroupIncludeAddHandler INSTANCE = new SocketBindingGroupIncludeAddHandler();
    private final ParameterValidator typeValidator = new StringLengthValidator(1);

    public static ModelNode getOperation(ModelNode address, String include) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("include").set(include);
        return op;
    }

    private SocketBindingGroupIncludeAddHandler() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode param = operation.get("include");
        ModelNode includes = model.get("include");
        this.typeValidator.validateParameter("include", param);
        includes.add(param);
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getAddSocketBindingGroupIncludeOperation(locale);
    }
}

