/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;

abstract class AbstractNodeRegistration
implements ModelNodeRegistration {
    private final String valueString;
    private final NodeSubregistry parent;

    AbstractNodeRegistration(String valueString, NodeSubregistry parent) {
        this.valueString = valueString;
        this.parent = parent;
    }

    @Override
    public abstract ModelNodeRegistration registerSubModel(PathElement var1, DescriptionProvider var2);

    @Override
    public void registerOperationHandler(String operationName, OperationHandler handler, DescriptionProvider descriptionProvider) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, false);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, inherited, OperationEntry.EntryType.PUBLIC);
    }

    @Override
    public abstract void registerOperationHandler(String var1, OperationHandler var2, DescriptionProvider var3, boolean var4, OperationEntry.EntryType var5);

    @Override
    public abstract void registerProxyController(PathElement var1, ProxyController var2) throws IllegalArgumentException;

    @Override
    public abstract void unregisterProxyController(PathElement var1);

    @Override
    public final OperationHandler getOperationHandler(PathAddress pathAddress, String operationName) {
        return this.getHandler((ListIterator<PathElement>)pathAddress.iterator(), operationName);
    }

    abstract OperationHandler getHandler(ListIterator<PathElement> var1, String var2);

    @Override
    public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
        return this.getAttributeAccess((ListIterator<PathElement>)address.iterator(), attributeName);
    }

    abstract AttributeAccess getAttributeAccess(ListIterator<PathElement> var1, String var2);

    @Override
    public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
        TreeMap<String, OperationEntry> providers = new TreeMap<String, OperationEntry>();
        this.getOperationDescriptions((ListIterator<PathElement>)address.iterator(), providers, inherited);
        return providers;
    }

    abstract void getOperationDescriptions(ListIterator<PathElement> var1, Map<String, OperationEntry> var2, boolean var3);

    @Override
    public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
        return this.getOperationDescription(address.iterator(), operationName);
    }

    abstract DescriptionProvider getOperationDescription(Iterator<PathElement> var1, String var2);

    @Override
    public DescriptionProvider getModelDescription(PathAddress address) {
        return this.getModelDescription(address.iterator());
    }

    abstract DescriptionProvider getModelDescription(Iterator<PathElement> var1);

    @Override
    public Set<String> getAttributeNames(PathAddress address) {
        return this.getAttributeNames(address.iterator());
    }

    abstract Set<String> getAttributeNames(Iterator<PathElement> var1);

    @Override
    public Set<String> getChildNames(PathAddress address) {
        return this.getChildNames(address.iterator());
    }

    abstract Set<String> getChildNames(Iterator<PathElement> var1);

    @Override
    public Set<PathElement> getChildAddresses(PathAddress address) {
        return this.getChildAddresses(address.iterator());
    }

    abstract Set<PathElement> getChildAddresses(Iterator<PathElement> var1);

    @Override
    public ProxyController getProxyController(PathAddress address) {
        return this.getProxyController(address.iterator());
    }

    abstract ProxyController getProxyController(Iterator<PathElement> var1);

    @Override
    public Set<ProxyController> getProxyControllers(PathAddress address) {
        HashSet<ProxyController> controllers = new HashSet<ProxyController>();
        this.getProxyControllers(address.iterator(), controllers);
        return controllers;
    }

    abstract void getProxyControllers(Iterator<PathElement> var1, Set<ProxyController> var2);

    @Override
    public ModelNodeRegistration getSubModel(PathAddress address) {
        return this.getNodeRegistration(address.iterator());
    }

    abstract ModelNodeRegistration getNodeRegistration(Iterator<PathElement> var1);

    @Override
    public Set<PathAddress> resolveAddress(PathAddress address) {
        HashSet<PathAddress> addresses = new HashSet<PathAddress>();
        this.resolveAddress(address, PathAddress.EMPTY_ADDRESS, addresses);
        return addresses;
    }

    abstract void resolveAddress(PathAddress var1, PathAddress var2, Set<PathAddress> var3);

    final String getLocationString() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getLocationString() + this.valueString + ")";
    }
}

